/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.eugene.yaml;

import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import org.codehaus.plexus.component.annotations.Component;
import org.nuiton.eugene.Template;
import org.nuiton.eugene.models.object.ObjectModel;
import org.nuiton.eugene.models.object.ObjectModelAssociationClass;
import org.nuiton.eugene.models.object.ObjectModelAttribute;
import org.nuiton.eugene.models.object.ObjectModelClass;
import org.nuiton.eugene.models.object.ObjectModelClassifier;
import org.nuiton.eugene.models.object.ObjectModelElement;
import org.nuiton.eugene.models.object.ObjectModelEnumeration;
import org.nuiton.eugene.models.object.ObjectModelGenerator;
import org.nuiton.eugene.models.object.ObjectModelInterface;
import org.nuiton.eugene.models.object.ObjectModelOperation;
import org.nuiton.eugene.models.object.ObjectModelParameter;
import org.nuiton.eugene.models.object.reader.yaml.KeyWords;

@Component(role=Template.class, hint="org.nuiton.eugene.yaml.PureYamlTemplatesGenerator")
public class PureYamlTemplatesGenerator
extends ObjectModelGenerator
implements KeyWords {
    public void generateFromModel(Writer output, ObjectModel input) throws IOException {
        output.write("%YAML 1.1\n---\n- syntaxe: 1.0\n\n");
        if (input.getName() != null) {
            output.write("- name: " + input.getName() + "\n");
        }
        if (input.getVersion() != null) {
            output.write("- version: " + input.getVersion() + "\n");
        }
        if (input.getTagValues() != null && !input.getTagValues().isEmpty()) {
            output.write("- tagvalues:\n");
            for (Map.Entry entry : input.getTagValues().entrySet()) {
                output.write("  - " + (String)entry.getKey() + ": " + (String)entry.getValue() + "\n");
            }
        }
        output.write("\n");
        if (input.getClasses() != null && !input.getClasses().isEmpty()) {
            for (ObjectModelClass objectModelClass : input.getClasses()) {
                if (objectModelClass instanceof ObjectModelAssociationClass) {
                    this.generateFromAssociationClass(output, (ObjectModelAssociationClass)objectModelClass);
                    continue;
                }
                this.generateFromClass(output, objectModelClass);
            }
        }
        if (input.getInterfaces() != null && !input.getInterfaces().isEmpty()) {
            for (ObjectModelInterface objectModelInterface : input.getInterfaces()) {
                this.generateFromInterface(output, objectModelInterface);
            }
        }
        if (input.getEnumerations() != null && !input.getEnumerations().isEmpty()) {
            for (ObjectModelEnumeration objectModelEnumeration : input.getEnumerations()) {
                this.generateFromEnumeration(output, objectModelEnumeration);
            }
        }
    }

    public String getFilenameForModel(ObjectModel model) {
        return model.getName() + ".yamlobjectmodel";
    }

    public void generateFromElement(Writer output, ObjectModelElement input, String indent) throws IOException {
        if (input.getName() != null) {
            output.write(indent + "- " + "name" + ": " + input.getName() + "\n");
        }
        if (input.getStereotypes() != null && !input.getStereotypes().isEmpty()) {
            for (String string : input.getStereotypes()) {
                output.write(indent + "- " + "stereotypes" + ": " + string + "\n");
            }
        }
        if (input.getComments() != null && !input.getComments().isEmpty()) {
            for (String string : input.getComments()) {
                output.write(indent + "- " + "comments" + ": " + string + "\n");
            }
        }
        if (input.getDocumentation() != null) {
            output.write(indent + "- " + "documentation" + ": " + input.getDocumentation() + "\n");
        }
        if (input.getTagValues() != null && !input.getTagValues().isEmpty()) {
            output.write("- tagvalues:\n");
            for (Map.Entry entry : input.getTagValues().entrySet()) {
                output.write("  - " + (String)entry.getKey() + ": " + (String)entry.getValue() + "\n");
            }
        }
        output.write(indent + "- " + "static" + ": " + String.valueOf(input.isStatic()) + "\n");
    }

    public void generateFromClassifier(Writer output, ObjectModelClassifier input) throws IOException {
        if (input.getInterfaces() != null && !input.getInterfaces().isEmpty()) {
            for (ObjectModelInterface objectModelInterface : input.getInterfaces()) {
                output.write("  - superinterfaces: " + objectModelInterface.getPackageName() + "." + objectModelInterface.getName());
            }
        }
        this.generateFromElement(output, (ObjectModelElement)input, "  ");
        output.write("  - inner: " + String.valueOf(input.isInner()) + "\n");
        if (input.getPackageName() != null) {
            output.write("  - package: " + input.getPackageName() + "\n");
        }
        if (input.getAttributes() != null && !input.getAttributes().isEmpty()) {
            for (ObjectModelAttribute attribute : input.getAttributes()) {
                this.generateFromAttribute(output, attribute);
            }
        }
        if (input.getOperations() != null && !input.getOperations().isEmpty()) {
            for (ObjectModelOperation operation : input.getOperations()) {
                this.generateFromOperation(output, operation);
            }
        }
    }

    public void generateFromClass(Writer output, ObjectModelClass input) throws IOException {
        output.write("- class:\n");
        output.write("  - abstract: " + String.valueOf(input.isAbstract()) + "\n");
        if (input.getSuperclasses() != null && !input.getSuperclasses().isEmpty()) {
            for (ObjectModelClass objectModelClass : input.getSuperclasses()) {
                output.write("  - superclasses: " + objectModelClass.getPackageName() + "." + objectModelClass.getName());
            }
        }
        this.generateFromClassifier(output, (ObjectModelClassifier)input);
        output.write("\n");
    }

    public void generateFromInterface(Writer output, ObjectModelInterface input) throws IOException {
        output.write("- interface:\n");
        this.generateFromClassifier(output, (ObjectModelClassifier)input);
        output.write("\n");
    }

    public void generateFromAssociationClass(Writer output, ObjectModelAssociationClass input) throws IOException {
        output.write("- associationclass:\n");
        if (input.getSuperclasses() != null && !input.getSuperclasses().isEmpty()) {
            for (ObjectModelClass objectModelClass : input.getSuperclasses()) {
                output.write("  - superclasses: " + objectModelClass.getPackageName() + "." + objectModelClass.getName());
            }
        }
        this.generateFromClassifier(output, (ObjectModelClassifier)input);
        output.write("  - abstract: " + String.valueOf(input.isAbstract()) + "\n");
        if (input.getParticipantsAttributes() != null && !input.getParticipantsAttributes().isEmpty()) {
            for (ObjectModelAttribute attribute : input.getParticipantsAttributes()) {
                output.write("  - participant:\n");
                if (attribute.getType() != null) {
                    output.write("    - name: " + attribute.getType() + "\n");
                }
                if (attribute.getName() == null) continue;
                output.write("    - type: " + attribute.getName() + "\n");
            }
        }
        output.write("\n");
    }

    public void generateFromEnumeration(Writer output, ObjectModelEnumeration input) throws IOException {
        output.write("- enumeration:\n");
        this.generateFromElement(output, (ObjectModelElement)input, "  ");
    }

    public void generateFromParameter(Writer output, ObjectModelParameter input, String indent) throws IOException {
        this.generateFromElement(output, (ObjectModelElement)input, indent);
        if (input.isOrdered()) {
            output.write(indent + "- " + "ordering" + ": " + "ordered" + "\n");
        } else {
            output.write(indent + "- " + "ordering" + ": " + "unordered" + "\n");
        }
        if (input.getType() != null) {
            output.write(indent + "- " + "type" + ": " + input.getType() + "\n");
        }
        if (input.getDefaultValue() != null) {
            output.write(indent + "- " + "defaultvalue" + ": " + input.getDefaultValue() + "\n");
        }
        output.write(indent + "- " + "minmultiplicity" + ": " + String.valueOf(input.getMinMultiplicity()) + "\n");
        output.write(indent + "- " + "maxmultiplicity" + ": " + String.valueOf(input.getMaxMultiplicity()) + "\n");
        output.write(indent + "- " + "unique" + ": " + String.valueOf(input.isUnique()) + "\n");
    }

    public void generateFromAttribute(Writer output, ObjectModelAttribute input) throws IOException {
        output.write("  - attribute:\n");
        this.generateFromParameter(output, (ObjectModelParameter)input, "    ");
        output.write("    - navigable: " + String.valueOf(input.isNavigable()) + "\n");
        output.write("    - transient: " + String.valueOf(input.isTransient()) + "\n");
        output.write("    - final: " + String.valueOf(input.isFinal()) + "\n");
        output.write("    - reversemaxmultiplicity: " + String.valueOf(input.getReverseMaxMultiplicity()) + "\n");
        if (input.getVisibility() != null) {
            output.write("    - visibility: " + input.getVisibility() + "\n");
        }
        if (input.isComposite()) {
            output.write("    - associationtype: composite\n");
        } else if (input.isAggregate()) {
            output.write("    - associationtype: aggregate\n");
        }
        if (input.getAssociationClass() != null) {
            output.write("    - associationclassname: " + input.getAssociationClass().getPackageName() + "." + input.getAssociationClass().getName() + "\n");
        }
    }

    public void generateFromOperation(Writer output, ObjectModelOperation input) throws IOException {
        output.write("  - attribute:\n");
        this.generateFromElement(output, (ObjectModelElement)input, "  ");
        output.write("    - abstract: " + String.valueOf(input.isAbstract()) + "\n");
        if (input.getVisibility() != null) {
            output.write("    - visibility: " + input.getVisibility() + "\n");
        }
        if (input.getBodyCode() != null) {
            output.write("    - bodeycode: " + input.getBodyCode() + "\n");
        }
        if (input.getReturnParameter() != null) {
            output.write("    - returnparameter:\n");
            this.generateFromParameter(output, input.getReturnParameter(), "      ");
        }
        if (input.getParameters() != null && !input.getParameters().isEmpty()) {
            for (ObjectModelParameter objectModelParameter : input.getParameters()) {
                output.write("    - parameter:\n");
                this.generateFromParameter(output, objectModelParameter, "      ");
            }
        }
    }
}

