package org.nuiton.eugene.test2.beangen;

import java.beans.PropertyChangeListener;
 import java.beans.PropertyChangeSupport;
 import java.io.Serializable;
 
public class PersonneDTO implements Serializable {

    protected final PropertyChangeSupport pcs;
    /**
     * PersonneDTO :
     */
    public PersonneDTO() {
        pcs = new PropertyChangeSupport(this);
    }

    /**
     * addPropertyChangeListener :
     * @param listener 
     */
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        pcs.addPropertyChangeListener(listener);
    }

    /**
     * addPropertyChangeListener :
     * @param propertyName 
     * @param listener 
     */
    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        pcs.addPropertyChangeListener(propertyName, listener);
    }

    /**
     * removePropertyChangeListener :
     * @param listener 
     */
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        pcs.removePropertyChangeListener(listener);
    }

    /**
     * removePropertyChangeListener :
     * @param propertyName 
     * @param listener 
     */
    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        pcs.removePropertyChangeListener(propertyName, listener);
    }

    /**
     * firePropertyChange :
     * @param propertyName 
     * @param oldValue 
     * @param newValue 
     */
    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        pcs.firePropertyChange(propertyName, oldValue, newValue);
    }


} //PersonneDTO
