/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gml3.bindings;

import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.LineString;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.List;
import javax.xml.namespace.QName;
import org.geotools.geometry.DirectPosition2D;
import org.geotools.gml2.bindings.GML2EncodingUtils;
import org.geotools.gml3.GML;
import org.geotools.xlink.XLINK;
import org.geotools.xml.Encoder;
import org.opengis.geometry.DirectPosition;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class GML3EncodingUtils {
    static DirectPosition[] positions(LineString line) {
        CoordinateSequence coordinates = line.getCoordinateSequence();
        DirectPosition[] dps = new DirectPosition[coordinates.size()];
        for (int i = 0; i < dps.length; ++i) {
            double x = coordinates.getOrdinate(i, 0);
            double y = coordinates.getOrdinate(i, 1);
            dps[i] = new DirectPosition2D(x, y);
        }
        return dps;
    }

    static URI toURI(CoordinateReferenceSystem crs) {
        if (crs == null) {
            return null;
        }
        try {
            String crsCode = GML2EncodingUtils.crs((CoordinateReferenceSystem)crs);
            if (crsCode != null) {
                return new URI(crsCode);
            }
            return null;
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    static URI crs(CoordinateReferenceSystem crs) {
        return GML3EncodingUtils.toURI(crs);
    }

    static CoordinateReferenceSystem getCRS(Geometry g) {
        return GML2EncodingUtils.getCRS((Geometry)g);
    }

    static String getID(Geometry g) {
        return GML2EncodingUtils.getID((Geometry)g);
    }

    static String getName(Geometry g) {
        return GML2EncodingUtils.getName((Geometry)g);
    }

    static String getDescription(Geometry g) {
        return GML2EncodingUtils.getDescription((Geometry)g);
    }

    static Object getProperty(Geometry geometry, QName name) {
        String id;
        if (GML._Geometry.equals(name) || GML.Point.equals(name) || GML.LineString.equals(name) || GML.Polygon.equals(name)) {
            if (GML3EncodingUtils.isEmpty(geometry)) {
                return null;
            }
            return geometry;
        }
        if (XLINK.HREF.equals(name) && GML3EncodingUtils.isEmpty(geometry) && (id = GML3EncodingUtils.getID(geometry)) != null) {
            return "#" + id;
        }
        return null;
    }

    static List getProperties(Geometry geometry) {
        String id = GML3EncodingUtils.getID(geometry);
        if (!GML3EncodingUtils.isEmpty(geometry) && id != null) {
            return Collections.singletonList(new Object[]{Encoder.COMMENT, "#" + id});
        }
        return null;
    }

    static boolean isEmpty(Geometry geometry) {
        if (geometry.isEmpty()) {
            return !(geometry instanceof GeometryCollection) || ((GeometryCollection)geometry).getNumGeometries() == 0;
        }
        return false;
    }
}

