/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gml3.bindings;

import javax.xml.namespace.QName;
import org.geotools.gml2.FeatureTypeCache;
import org.geotools.gml3.GML;
import org.geotools.gml3.bindings.GML3ParsingUtils;
import org.geotools.xml.AbstractComplexBinding;
import org.geotools.xml.BindingWalkerFactory;
import org.geotools.xml.ElementInstance;
import org.geotools.xml.Node;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.geometry.BoundingBox;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class AbstractFeatureTypeBinding
extends AbstractComplexBinding {
    FeatureTypeCache ftCache;
    BindingWalkerFactory bwFactory;

    public AbstractFeatureTypeBinding(FeatureTypeCache ftCache, BindingWalkerFactory bwFactory) {
        this.ftCache = ftCache;
        this.bwFactory = bwFactory;
    }

    public QName getTarget() {
        return GML.AbstractFeatureType;
    }

    public Class getType() {
        return SimpleFeature.class;
    }

    public Object parse(ElementInstance instance, Node node, Object value) throws Exception {
        return GML3ParsingUtils.parseFeature(instance, node, value, this.ftCache, this.bwFactory);
    }

    public Element encode(Object object, Document document, Element value) throws Exception {
        SimpleFeature feature = (SimpleFeature)object;
        SimpleFeatureType featureType = feature.getFeatureType();
        String namespace = featureType.getName().getNamespaceURI();
        String typeName = featureType.getTypeName();
        Element encoding = document.createElementNS(namespace, typeName);
        encoding.setAttributeNS("http://www.opengis.net/gml", "id", feature.getID());
        return encoding;
    }

    public Object getProperty(Object object, QName name) throws Exception {
        SimpleFeature feature = (SimpleFeature)object;
        if (GML.name.equals(name)) {
            return feature.getAttribute("name");
        }
        if (GML.description.equals(name)) {
            return feature.getAttribute("description");
        }
        if (GML.location.equals(name)) {
            return feature.getAttribute("location");
        }
        if (GML.boundedBy.equals(name)) {
            BoundingBox bounds = feature.getBounds();
            if (bounds.isEmpty() && feature.getDefaultGeometry() == null) {
                return null;
            }
            return feature.getBounds();
        }
        return null;
    }
}

