/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.vradi.services.tasks;

import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.Properties;
import java.util.TimerTask;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.vradi.VradiServiceConfigurationHelper;
import org.chorem.vradi.beans.XmlStreamImportResult;
import org.chorem.vradi.entities.XmlStream;
import org.chorem.vradi.services.VradiException;
import org.chorem.vradi.services.managers.BindingManager;
import org.nuiton.i18n.I18n;
import org.nuiton.util.ApplicationConfig;
import org.nuiton.util.ExceptionUtil;
import org.nuiton.util.TimeLog;
import org.nuiton.wikitty.WikittyProxy;

public class ImportXmlStreamTasks
extends TimerTask {
    private static final Log log = LogFactory.getLog(ImportXmlStreamTasks.class);
    private static final TimeLog timeLog = new TimeLog(ImportXmlStreamTasks.class, 5000L, 1000L);
    protected ApplicationConfig config;
    protected WikittyProxy wikittyProxy;
    protected BindingManager bindingManager;
    protected XmlStreamImportResult importResult;
    protected String xmlStreamId;

    public ImportXmlStreamTasks(ApplicationConfig config, WikittyProxy wikittyProxy, BindingManager bindingManager, String xmlStreamId) {
        this.config = config;
        this.wikittyProxy = wikittyProxy;
        this.bindingManager = bindingManager;
        this.xmlStreamId = xmlStreamId;
    }

    @Override
    public void run() {
        long start = TimeLog.getTime();
        try {
            XmlStream xmlStream = (XmlStream)this.wikittyProxy.restore(XmlStream.class, this.xmlStreamId);
            if (log.isInfoEnabled()) {
                log.info((Object)("Starting xml stream import on : " + xmlStream.getName() + "..."));
            }
            this.importResult = this.bindingManager.importFormsFromXmlStream(xmlStream);
            if (log.isInfoEnabled()) {
                log.info((Object)("Xml stream " + xmlStream.getName() + " imported : " + this.importResult.getCreatedFormCount() + " new forms."));
            }
        }
        catch (VradiException eee) {
            if (log.isErrorEnabled()) {
                log.error((Object)("Can't import forms from stream " + this.xmlStreamId), (Throwable)eee);
            }
            this.sendEmailError(this.xmlStreamId, eee);
        }
        timeLog.log(start, "importXmlStreamTasks");
    }

    protected void sendEmailError(String xmlStreamId, VradiException error) {
        log.info((Object)"Error is occured, sending error email");
        XmlStream xmlStream = (XmlStream)this.wikittyProxy.restore(XmlStream.class, xmlStreamId);
        List<String> mailAdmin = VradiServiceConfigurationHelper.getMailAdmin(this.config);
        for (String email : mailAdmin) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Sending error email to " + email));
            }
            if (StringUtils.isBlank((String)email)) {
                if (log.isWarnEnabled()) {
                    log.warn((Object)("Email is empty : " + email));
                }
                return;
            }
            Properties props = new Properties();
            props.put("mail.smtp.host", VradiServiceConfigurationHelper.getSmtpHost(this.config));
            props.put("mail.smtp.port", (Object)VradiServiceConfigurationHelper.getSmtpPort(this.config));
            Session session = Session.getInstance((Properties)props, (Authenticator)new Authenticator(){

                protected PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(VradiServiceConfigurationHelper.getMailUser(ImportXmlStreamTasks.this.config), VradiServiceConfigurationHelper.getMailPassword(ImportXmlStreamTasks.this.config));
                }
            });
            MimeMessage msg = new MimeMessage(session);
            try {
                InternetAddress addressFrom = new InternetAddress(VradiServiceConfigurationHelper.getMailFrom(this.config), VradiServiceConfigurationHelper.getMailFromName(this.config));
                msg.setFrom((Address)addressFrom);
                InternetAddress addressTo = new InternetAddress(email);
                msg.addRecipient(Message.RecipientType.TO, (Address)addressTo);
                MimeMultipart multiparts = new MimeMultipart();
                MimeBodyPart msgBodyPart = new MimeBodyPart();
                msgBodyPart.setText(I18n._((String)"vradi.error.errorImportXmlStream", (Object[])new Object[]{xmlStream.getName(), ExceptionUtil.stackTrace((Throwable)error)}));
                multiparts.addBodyPart((BodyPart)msgBodyPart);
                msg.setContent((Multipart)multiparts);
                msg.setSubject(I18n._((String)"vradi.error.errorImportXmlStream.subject", (Object[])new Object[]{xmlStream.getName()}));
                try {
                    Transport.send((Message)msg);
                }
                catch (MessagingException eee) {
                    if (!log.isErrorEnabled()) continue;
                    log.error((Object)"Cant send mail", (Throwable)eee);
                }
            }
            catch (MessagingException eee) {
                if (!log.isErrorEnabled()) continue;
                log.error((Object)"Can't generate message", (Throwable)eee);
            }
            catch (UnsupportedEncodingException eee) {
                if (!log.isErrorEnabled()) continue;
                log.error((Object)"Can't generate message", (Throwable)eee);
            }
        }
    }
}

