/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.vradi.services;

import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.vradi.VradiServiceConfiguration;
import org.chorem.vradi.VradiServiceConfigurationHelper;
import org.chorem.vradi.entities.ClientImpl;
import org.chorem.vradi.entities.FormImpl;
import org.chorem.vradi.entities.GroupFormsImpl;
import org.chorem.vradi.entities.GroupImpl;
import org.chorem.vradi.entities.InfogeneImpl;
import org.chorem.vradi.entities.ModificationTagImpl;
import org.chorem.vradi.entities.QueryMakerImpl;
import org.chorem.vradi.entities.RootThesaurusImpl;
import org.chorem.vradi.entities.SendingImpl;
import org.chorem.vradi.entities.SessionImpl;
import org.chorem.vradi.entities.StatusImpl;
import org.chorem.vradi.entities.ThesaurusImpl;
import org.chorem.vradi.entities.UserImpl;
import org.chorem.vradi.entities.VradiUserImpl;
import org.chorem.vradi.entities.WebHarvestStreamImpl;
import org.chorem.vradi.entities.XmlFieldBindingImpl;
import org.chorem.vradi.entities.XmlStreamImpl;
import org.chorem.vradi.services.ServiceMigration;
import org.chorem.vradi.services.VradiStorageService;
import org.chorem.vradi.services.VradiStorageServiceImpl;
import org.nuiton.i18n.I18n;
import org.nuiton.util.ApplicationConfig;
import org.nuiton.util.converter.ConverterUtil;
import org.nuiton.wikitty.WikittyProxy;
import org.nuiton.wikitty.WikittyService;
import org.nuiton.wikitty.WikittyServiceFactory;
import org.nuiton.wikitty.entities.WikittyExtension;
import org.nuiton.wikitty.entities.WikittyTreeNodeImpl;
import org.nuiton.wikitty.entities.WikittyUserImpl;

public class ServiceFactory {
    private static final Log log = LogFactory.getLog(ServiceFactory.class);
    protected static WikittyService vradiWikittyService;
    protected static VradiStorageService vradiStorageService;
    protected static WikittyProxy wikittyProxy;
    protected static ApplicationConfig config;

    public static synchronized VradiStorageService getVradiStorageService() {
        if (vradiStorageService == null) {
            vradiStorageService = new VradiStorageServiceImpl();
        }
        return vradiStorageService;
    }

    public static synchronized WikittyService getWikittyService() {
        if (vradiWikittyService == null) {
            ServiceFactory.getWikittyService(config);
        }
        return vradiWikittyService;
    }

    public static synchronized WikittyService getWikittyService(ApplicationConfig config) {
        if (vradiWikittyService == null) {
            vradiWikittyService = WikittyServiceFactory.buildWikittyService((ApplicationConfig)config);
        }
        return vradiWikittyService;
    }

    public static synchronized WikittyProxy getWikittyProxy() {
        if (wikittyProxy == null) {
            WikittyService wikittyService = ServiceFactory.getWikittyService();
            wikittyProxy = new WikittyProxy(wikittyService);
            ServiceFactory.updateExtensions(wikittyProxy);
            ServiceFactory.reindexData(wikittyProxy);
        }
        return wikittyProxy;
    }

    static void updateExtensions(WikittyProxy localWikittyProxy) {
        List<WikittyExtension> extensions = Arrays.asList(ClientImpl.extensionClient, FormImpl.extensionForm, GroupImpl.extensionGroup, InfogeneImpl.extensionInfogene, ModificationTagImpl.extensionModificationTag, QueryMakerImpl.extensionQueryMaker, RootThesaurusImpl.extensionRootThesaurus, SendingImpl.extensionSending, SessionImpl.extensionSession, StatusImpl.extensionStatus, ThesaurusImpl.extensionThesaurus, WikittyTreeNodeImpl.extensionWikittyTreeNode, UserImpl.extensionUser, VradiUserImpl.extensionVradiUser, WebHarvestStreamImpl.extensionWebHarvestStream, WikittyUserImpl.extensionWikittyUser, XmlFieldBindingImpl.extensionXmlFieldBinding, XmlStreamImpl.extensionXmlStream, GroupFormsImpl.extensionGroupForms);
        localWikittyProxy.storeExtension(extensions);
    }

    protected static void reindexData(WikittyProxy localWikittyProxy) {
        try {
            String currentVersion = VradiServiceConfigurationHelper.getApplicationVersion(config);
            String lastVersion = VradiServiceConfigurationHelper.getServiceVersion(config);
            if (!currentVersion.equals(lastVersion)) {
                ServiceMigration.versionChangeMigration(lastVersion, currentVersion, localWikittyProxy);
                VradiServiceConfigurationHelper.setServiceVersion(config, currentVersion);
                config.saveForUser(new String[0]);
            } else if (log.isInfoEnabled()) {
                log.info((Object)"No version change, skipping reindexing.");
            }
            ServiceMigration.configureMigration();
        }
        catch (Exception eee) {
            log.error((Object)"Failled to reindex data : ", (Throwable)eee);
        }
    }

    static {
        try {
            ConverterUtil.initConverters();
            config = VradiServiceConfiguration.getConfig(new String[0]);
            I18n.setDefaultLocale((Locale)VradiServiceConfigurationHelper.getLocale(config));
        }
        catch (Exception eee) {
            log.error((Object)"Cant initialize Service factory : ", (Throwable)eee);
        }
    }
}

