/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.votecounting.impl.borda;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.chorem.pollen.votecounting.api.AbstractVoteCountingStrategy;
import org.chorem.pollen.votecounting.api.model.ChoiceScore;
import org.chorem.pollen.votecounting.api.model.VoteCountingResult;
import org.chorem.pollen.votecounting.api.model.VoteForChoice;
import org.chorem.pollen.votecounting.api.model.Voter;
import org.chorem.pollen.votecounting.impl.borda.BordaChoiceRank;
import org.chorem.pollen.votecounting.impl.borda.BordaConfig;
import org.chorem.pollen.votecounting.impl.borda.BordaDetailResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BordaVoteCountingStrategy
extends AbstractVoteCountingStrategy<BordaConfig> {
    private static final Logger log = LoggerFactory.getLogger(BordaVoteCountingStrategy.class);

    public BordaVoteCountingStrategy() {
        super(BordaConfig.class);
    }

    @Override
    public VoteCountingResult voteCount(Set<Voter> voters) {
        Map<String, ChoiceScore> scores = this.newEmptyChoiceScoreMap(voters);
        BordaDetailResult detailResult = new BordaDetailResult();
        int nbChoices = scores.size();
        if (log.isDebugEnabled()) {
            log.debug("Nb choices: " + nbChoices);
        }
        int nbRanks = nbChoices;
        if (((BordaConfig)this.config).getMaxChoiceNumber() > 0) {
            nbRanks = ((BordaConfig)this.config).getMaxChoiceNumber();
        }
        Map<Voter, List<Set<String>>> voterSortedChoices = this.buildVoterSortedChoices(voters);
        block0: for (Map.Entry<Voter, List<Set<String>>> entry : voterSortedChoices.entrySet()) {
            Voter voter = entry.getKey();
            double weight = voter.getWeight();
            List<Integer> pointsByRank = ((BordaConfig)this.config).getPointsByRank();
            int rank = 0;
            for (Set<String> sortedChoiceId : entry.getValue()) {
                double choiceWeight = CollectionUtils.isNotEmpty(pointsByRank) ? (pointsByRank.size() > rank ? (double)pointsByRank.get(rank).intValue() * weight : 0.0) : (double)(nbRanks - rank) * weight;
                for (String choiceId : sortedChoiceId) {
                    scores.get(choiceId).addScoreValue(choiceWeight);
                    this.addChoiceRank(detailResult, choiceId, rank, weight);
                }
                if (++rank <= nbRanks) continue;
                continue block0;
            }
        }
        return this.orderByValues(scores.values(), detailResult);
    }

    @Override
    public Set<VoteForChoice> toVoteForChoices(VoteCountingResult voteCountingResult) {
        HashSet voteForChoices = Sets.newHashSet();
        for (ChoiceScore choiceScore : voteCountingResult.getScores()) {
            double score = choiceScore.getScoreOrder();
            VoteForChoice voteForChoice = VoteForChoice.newVote(choiceScore.getChoiceId(), score);
            voteForChoices.add(voteForChoice);
        }
        return voteForChoices;
    }

    protected void addChoiceRank(BordaDetailResult detailResult, String choiceId, int rank, double score) {
        BordaChoiceRank choiceRank;
        Optional<BordaChoiceRank> choiceRankOptional = detailResult.getChoiceRanks().stream().filter(cr -> cr.getChoiceId().equals(choiceId) && cr.getRank() == rank).findFirst();
        if (choiceRankOptional.isPresent()) {
            choiceRank = choiceRankOptional.get();
        } else {
            choiceRank = new BordaChoiceRank();
            choiceRank.setChoiceId(choiceId);
            choiceRank.setRank(rank);
            detailResult.getChoiceRanks().add(choiceRank);
        }
        choiceRank.addScoreValue(score);
    }
}

