/*
 * #%L
 * Pollen :: UI (struts2)
 * $Id: favoriteList.js 3702 2012-09-23 13:48:42Z tchemit $
 * $HeadURL: http://svn.chorem.org/svn/pollen/tags/pollen-1.5.5/pollen-ui-struts2/src/main/webapp/js/favoriteList.js $
 * %%
 * Copyright (C) 2009 - 2012 CodeLutin, Tony Chemit
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
function initFavoritePage(action) {
    if (action == 'create') {
        $('#createForm').show();
    } else if (action == 'edit') {
        $('#editForm').show();
    }

    // listen row selection
    $.addRowSelectTopic('pollAccounts', function () {
        if (action != '') {
            // come back from action
            action = '';
            return;
        }
        $(".pollAccountForm").hide();
    });

    $.addClearSelectTopic('pollAccounts', function () {
        if (action != '') {
            // come back from action
            action = '';
            return;
        }
        $(".pollAccountForm").hide();
    });

    // to create a new row
    $.listenRowTopic('pollAccounts-addRow', function () {
        $('#createForm [name="createPollAccount.votingId"]').val("");
        $('#createForm [name="createPollAccount.email"]').val("");
        $('#deleteForm').hide();
        $('#editForm').hide();
        $('#createForm').show();
    });
}

function favoriteListFunctions(cellvalue, options, rowObject) {

    var id = rowObject.id;

    var result = "";

    var script = 'return editPollAccount("' + id + '");';
    result += formatLinkByScript(script, editImg, "Edit", editTitle);

    script = 'return confirmDelete("' + id + '");';
    result += formatLinkByScript(script, deleteImg, "Delete", deleteTitle);
    return result;
}

function formatLinkByScript(script, image, imageAlt, imageTitle) {
    return "<a href='#' onclick='" + script + "'><image alt='" + imageAlt + "' title='" + imageTitle + "' src='" + image + "'> </a>";
}

// to edit the selected row
function editPollAccount(id) {

    jQuery.getJSON(
            loadPollActionUrl, { "pollAccountId":id }, function (result) {

                var pollAccount = result.data;
                $('#editForm [name="editPollAccount.topiaId"]').val(pollAccount.id);
                $('#editForm [name="editPollAccount.votingId"]').val(pollAccount.votingId);
                $('#editForm [name="editPollAccount.email"]').val(pollAccount.email);
                $('#deleteForm').hide();
                $('#createForm').hide();
                $('#editForm').show();
            }
    );
}

function confirmDelete(id) {
    $('.ui-dialog-title').html(deleteTitle);
    var dialog = $("#confirmDialog");
    var url = deleteUrl + '?' + $.param({favoriteListId:favoriteListId,
                                            pollAccountId:id,
                                            redirectUrl:redirectUrl});
    dialog.load(url);
    dialog.dialog('open');
    return false;
}
