/*
 * #%L
 * Pollen :: UI (struts2)
 * $Id: createPoll.js 3777 2013-04-28 19:08:18Z tchemit $
 * $HeadURL: http://svn.chorem.org/svn/pollen/tags/pollen-1.5.5/pollen-ui-struts2/src/main/webapp/js/createPoll.js $
 * %%
 * Copyright (C) 2009 - 2012 CodeLutin, Tony Chemit
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
var datas = $(document).data();

function selectPersonListToAddToVotingList(votingListType, containerId, votingListNumber) {
    $('.ui-dialog-title').html(datas['selectPersonListToAddToVotingListTitle']);
    var dialog = $("#selectPersonListDialog");
    var url = datas['selectPersonListToAddToVotingListUrl'];
    url += '?' + $.param(
            {votingListType:votingListType, containerId:containerId,
                votingListNumber:votingListNumber  });
    dialog.load(url);
    dialog.dialog('open');
    return false;
}

function selectPersonListToCreateNewVotingList() {
    $('.ui-dialog-title').html(datas['selectPersonListToCreateNewVotingListTitle']);
    var dialog = $("#selectPersonListDialog");
    var url = datas['selectPersonListToCreateNewVotingListUrl'];
    dialog.load(url);
    dialog.dialog('open');
    return false;
}


//----------------------------------------------------------------------------
//-- Voting List methods
//----------------------------------------------------------------------------

function getLastVotingList(containerId) {
    var result = 0;
    getAllVotingLists(containerId).each(function () {
        var current = $(this).data('votingListNumber');
        if (current > result) {
            result = current;
        }
    });
    return result;
}

function getAllVotingLists(containerId) {
    return $("div[id^='" + containerId + "_'].votingList");
}

function prepareVotingLists(containerId) {

    getAllVotingLists(containerId).each(function (index) {

        var votingListId = containerId + "_" + index;
        var votingList = $("#" + votingListId);
        votingList.data('votingListNumber', index);
        votingList.data('votingListContainerId', containerId);

        preparePersonToLists(votingListId + 'PersonToList', index);

    });
    updateUpdownVotingListActions(containerId);
}

function prepareVotingList(containerId, votingListNumber) {

    var votingListId = containerId + "_" + votingListNumber;
    var votingList = $("#" + votingListId);
    votingList.data('votingListNumber', votingListNumber);
    votingList.data('votingListContainerId', containerId);
    preparePersonToLists(votingListId + 'PersonToList', votingListNumber);
    updateUpdownVotingListActions(containerId);
}

function updateUpdownVotingListActions(containerId) {
    getAllVotingLists(containerId).each(function (index) {
        var currentVotingListNumber = $(this).data('votingListNumber');
        var labelWidget = $('#' + containerId + "_" + currentVotingListNumber + "_label");
        labelWidget.html(datas['votingListText'] + ' ' + (index + 1));
    });
}

function addNewVotingList() {

    var containerId = 'votingListGROUP';
    var votingListNumber = 1 + getLastVotingList(containerId);

    $.ajax({
               url:datas['displayVotingListUrl'],
               data:{
                   votingListType:'GROUP',
                   votingListNumber:votingListNumber
               },
               async:false,
               dataType:"html",
               success:function (data) {
                   var container = $("#" + containerId);
                   container.append(data);
                   // store votingListNumber and updates personToLists
                   prepareVotingList(containerId, votingListNumber);
               }
           });
    return false;
}

function importPersonListToNewVotingList(personListId, cancelCallBack) {

    var containerId = 'votingListGROUP';

    // get new voting list number
    var votingListNumber = 1 + getLastVotingList(containerId);

    $.ajax(
            {
                url:datas['importPersonListToNewVotingListUrl'],
                data:{
                    votingListType:"GROUP",
                    votingListNumber:votingListNumber,
                    personListId:personListId
                },
                async:false,
                dataType:"html",
                success:function (data) {
                    var container = $("#" + containerId);
                    container.append(data);
                    prepareVotingList(containerId, votingListNumber);
                }
            }
    );
    return cancelCallBack();
}

function deleteVotingList(votingListId) {
    var votingList = $('#' + votingListId);
    var containerId = votingList.data('votingListContainerId');
    votingList.remove();
    updateUpdownVotingListActions(containerId);
    return false;
}


//----------------------------------------------------------------------------
//-- PersonToList methods
//----------------------------------------------------------------------------

function getLastPersonToList(containerId) {
    var result = 0;
    getAllPersonToLists(containerId).each(function () {
        var current = $(this).data('personToListNumber');
        if (current > result) {
            result = current;
        }
    });
    return result;
}

function getAllPersonToLists(containerId) {
    return $("div[id^='" + containerId + "_'].personToList");
}

function getAllPersonToListNumbers(containerId) {
    var result = [];
    getAllPersonToLists(containerId).each(function () {
        var current = $(this).data('personToListNumber');
        result.push(current);
    });
    return result;
}

function getFirstEmptyPersonToList(containerId) {
    var result = -1;
    var numbers = getAllPersonToListNumbers(containerId);
    $.each(numbers, function () {
        var n = $(this)[0];
        if (result == -1) {
            var nameInput = $('[name="' + containerId + '_' + n + '.votingId"]');
            var emailInput = $('[name="' + containerId + '_' + n + '.email"]');

            var name = nameInput.val();
            var email = emailInput.val();
            if (name == '' && email == '') {
                result = n;
            }
        }
    });
    return result;
}

function preparePersonToList(containerId, votingListNumber, personToListNumber) {
    var personToList = $("#" + containerId + "_" + personToListNumber);

    personToList.data('votingListNumber', votingListNumber);
    personToList.data('personToListNumber', personToListNumber);
    personToList.data('personToListContainerId', containerId);
    updateUpdownPersonToListActions(containerId);
}

function preparePersonToLists(containerId, votingListNumber) {
    getAllPersonToLists(containerId).each(function (index) {

        preparePersonToList(containerId, votingListNumber, index);
    });
}

function updateUpdownPersonToListActions(containerId) {

    getAllPersonToLists(containerId).each(function (index) {

        var currentPersonToListNumber = $(this).data('personToListNumber');
        var labelWidget = $('#' + containerId + "_" + currentPersonToListNumber + "_label");
        labelWidget.html(datas['personToListText'] + ' ' + (index + 1));
    });
}

function addNewPersonToList(votingListType, containerId, votingListNumber) {

    var personToListNumber = 1 + getLastPersonToList(containerId);
    $.ajax({
               url:datas['displayPersonToListUrl'],
               data:{
                   votingListNumber:votingListNumber,
                   votingListType:votingListType,
                   personToListNumber:personToListNumber
               },
               async:false,
               dataType:"html",
               success:function (data) {
                   var container = $("#" + containerId);
                   container.append(data);
                   // store personToListNumber
                   preparePersonToList(containerId, votingListNumber, personToListNumber);
               }
           });
    return false;
}

function deletePersonToList(personToListId) {
    var personToList = $('#' + personToListId);
    var containerId = personToList.data('personToListContainerId');
    personToList.remove();
    updateUpdownPersonToListActions(containerId);
    return false;
}

function addPersonListToVotingList(votingListType, containerId, votingListNumber, personListId, cancelCallBack) {

    // get first personToList available position
    var firstNumber = getFirstEmptyPersonToList(containerId);
    if (firstNumber == -1) {
        // no personToList available
        // let's take a new one (max +1)
        firstNumber = 1 + getLastPersonToList(containerId);
    } else {
        // remove all empty personToList
        var numbers = getAllPersonToListNumbers(containerId);
        for (var n in numbers) {
            if (n >= firstNumber) {
                deletePersonToList(containerId + "_" + n);
            }
        }
    }

    $.ajax(
            {
                url:datas['importPersonListToVotingListUrl'],
                data:{
                    votingListType:votingListType,
                    votingListNumber:votingListNumber,
                    personListId:personListId,
                    startNumber:firstNumber
                },
                async:false,
                dataType:"html",
                success:function (data) {
                    var container = $("#" + containerId);
                    container.append(data);
                    preparePersonToLists(containerId, votingListNumber);
                }
            }
    );
    return cancelCallBack();
}

//----------------------------------------------------------------------------
//-- Choice methods
//----------------------------------------------------------------------------

function getFirstChoice(containerId) {
    var result = 65535;

    getAllChoices(containerId).each(function () {
        var currentChoiceNumber = $(this).data('choiceNumber');
        if (currentChoiceNumber < result) {
            result = currentChoiceNumber;
        }
    });
    return result;
}

function getLastChoice(containerId) {
    var result = 0;
    getAllChoices(containerId).each(function () {
        var currentChoiceNumber = $(this).data('choiceNumber');
        if (currentChoiceNumber > result) {
            result = currentChoiceNumber;
        }
    });
    return result;
}

function getAllChoices(containerId) {
    return $("div[id^='" + containerId + "_']");
}

function prepareChoices(containerId, choicePrefix) {

    getAllChoices(containerId).each(function (index) {

        var choice = $("#" + containerId + "_" + index);
        choice.data('choiceType', containerId);
        choice.data('choiceNumber', index);
        choice.data('choicePrefix', choicePrefix);
    });

    if (containerId == 'choicesDATE') {

        getAllChoices(containerId).each(function (index) {
            var choice = $("#" + containerId + "_" + index + " script");
            $('[id="wwctrl_dateChoice_' + index + '.name"] input').detach().insertBefore(choice);
            $('[id="wwctrl_dateChoice_' + index + '.name"] button').detach().insertBefore(choice);

        });

        $('#choicesDATE .wwgrp').remove();
    }

    if (containerId == 'choicesIMAGE') {

        getAllChoices(containerId).each(function (index) {

            // prepare image to enable click on image to select file
            prepareImageChoice(index);
        });
    }
    updateUpdownActions(containerId);
}

function prepareImageChoice(index) {

    // click on hidden input file on click on image
    var imageChoice = $('[name="imageChoice_' + index + '.thumb"]');
    var data = {imageIndex:index};
    imageChoice.click(data, function(evt){
        var index = evt.data['imageIndex'];
        var inputImageChoice = $('[name="imageChoice[' + index + ']"]');
        inputImageChoice.trigger('click');
    });

    // update image as selected
    var inputImageChoice = $('[name="imageChoice[' + index + ']"]');
    inputImageChoice.change(data, function(evt) {
        var index = evt.data['imageIndex'];
        var imageChoice = $('[name="imageChoice_' + index + '.thumb"]');
        imageChoice.attr("src", "/pollen/img/7terOk.jpg");
        imageChoice.attr("title", this.value);
        imageChoice.attr("alt", this.value);
    });
}

function updateUpdownActions(containerId) {

    reorder(containerId);
}

function loadChoice(containerId, choicePrefix, url, choiceNumber, nbChoices, tokenId) {
    if (choiceNumber == -1) {

        // to add a new choice
        // get new choiceNumber

        choiceNumber = 1 + getLastChoice(containerId);
    }
    $.ajax(
            {
                url:url,
                data:{ tokenId:tokenId, choiceNumber:choiceNumber },
                async:false,
                dataType:"html",
                success:function (data) {
                    var container = $("#" + containerId);
                    container.append(data);
                    // store choiceNumber and choiceType
                    var choice = $("#" + containerId + "_" + choiceNumber);
                    choice.data('choiceType', containerId);
                    choice.data('choiceNumber', choiceNumber);
                    choice.data('choicePrefix', choicePrefix);
                    if (choiceNumber == nbChoices) {

                        updateUpdownActions(containerId);
                        // end it can show it
                        var classes = container.attr("class");
                        if (classes.indexOf("thischoice") > -1) {
                            // show it
                            container.removeClass('hidden');
                        }
                    }
                    if (!tokenId) {
                        updateUpdownActions(containerId);
                    }
                }
            });

    return choiceNumber;
}

function addTextChoice(choiceNumber, nbChoices, tokenId) {
    loadChoice(
            'choicesTEXT', 'textChoice_',
            datas['displayTextChoiceUrl'],
            choiceNumber, nbChoices, tokenId
    );
}

function addDateChoice(choiceNumber, nbChoices, tokenId) {
    loadChoice(
            'choicesDATE', 'dateChoice_',
            datas['displayDateChoiceUrl'],
            choiceNumber, nbChoices, tokenId
    );
}

function addImageChoice(choiceNumber, nbChoices, tokenId) {
    choiceNumber = loadChoice('choicesIMAGE', 'imageChoice_',
               datas['displayImageChoiceUrl'],
               choiceNumber, nbChoices, tokenId
    );

    // prepare image to enable click on image to select file
    prepareImageChoice(choiceNumber);
}

function addNewChoice() {
    var type = $('[name="poll.choiceType"][checked="checked"]').val();
    if ("TEXT" == type) {
        addTextChoice(-1, -1);
    } else if ("DATE" == type) {
        addDateChoice(-1, -1);
    } else if ("IMAGE" == type) {
        addImageChoice(-1, -1);
    }
    return false;
}

function deleteChoice(choiceId) {
    var choice = $('#' + choiceId);
    var containerId = choice.data('choiceType');
    choice.remove();
    updateUpdownActions(containerId);
    return false;
}

function confirmClose() {
    $('.ui-dialog-title').html(datas['confirmCloseTitle']);
    var dialog = $("#confirmDialog");
    var url = datas['confirmCloseUrl'] + '?'
            + $.param({redirectUrl:datas['confirmCloseRedirectUrl']});
    dialog.load(url);
    dialog.dialog('open');
    return false;
}

function disablePoll() {
    $('#registerForm input, textarea').attr('disabled', true);
    $('#registerForm :button, fieldset a, :submit, input[type="file"]').hide();
}

function disableWhenVoteStarted() {
    $('#registerForm input.disableForVoteStarted').attr('disabled', true);
    $('#registerForm textarea.disableForVoteStarted').attr('disabled', true);
    $('#'+$('#registerForm input.disableForVoteStarted').parent().attr('id')+' button').hide();
    $('#registerForm .disableForVoteStarted input').attr('disabled', true);
    $('#registerForm .disableForVoteStarted textarea').attr('disabled', true);
    $('#registerForm .disableForVoteStarted :button').hide();
    $('#registerForm .disableForVoteStarted fieldset a').hide();
    $('#registerForm .disableForVoteStarted :submit').hide();
    $('#registerForm .disableForVoteStarted input[type="file"]').hide();
}

function reorder(containerId) {

    var choices = getAllChoices(containerId);

    choices.each(function (index) {

        var currentChoiceNumber = $(this).data('choiceNumber');

        var choicePrefix = $(this).data('choicePrefix');

        $('#' + containerId + "_label_" + currentChoiceNumber).html(
                datas['choiceText'] + ' ' + (index + 1));

        var orderWidget = $('[name="' + choicePrefix + currentChoiceNumber +".order" + '"]');

        orderWidget.val(index);
    });

}
jQuery(document).ready(function () {

    function changeChoiceAddAllowed(val) {
        $('[name="poll.beginChoiceDate"],[name="poll.endChoiceDate"]').attr(
                'disabled', !val);
    }

    function changeLimitChoice(val) {
        $('[name="maxChoices"]').attr('disabled', !val);
    }

    function changeReminder(val) {
        $('[name="reminderHourCountdown"]').attr('disabled', !val);
    }

    function changeAnonymousOption(val) {
        $('[name="poll.anonymousVoteAllowed"]').attr('disabled', val);
    }

    function disableAll() {
        $("#" + $(this).attr('id') + " :input").attr('disabled', true);
    }

    function undisableAll() {
        $("#" + $(this).attr('id') + " :input").attr('disabled', false);
    }

    function changePollType(type) {
        var container = $('#pollType' + type);

        // traitement des autres containers de type
        $('.pollType').not(container).
                addClass('hidden').removeClass('thispoll').
                each(disableAll);
        // traitement du nouveau container de type
        container.removeClass('hidden').addClass('thispoll').
                each(undisableAll);

        $('[name="poll.pollType"]').attr('checked', false);
        $('[name="poll.pollType"][value="' + type + '"]').attr('checked', 'checked');
    }

    function changeChoiceType(type) {
        var container = $('#choices' + type);
        // traitement des autres containers de choix
        $('.choices').not(container).
                addClass('hidden').removeClass('thischoice').
                each(disableAll);
        // traitement du nouveau container de choix
        container.removeClass('hidden').
                addClass('thischoice').each(undisableAll);

        $('[name="poll.choiceType"]').attr('checked', false);
        $('[name="poll.choiceType"][value="' + type + '"]').attr('checked', 'checked');
    }

    $('[name="poll.choiceAddAllowed"]').change(function () {
        changeChoiceAddAllowed($(this).prop('checked'));
    });

    $('[name="poll.anonymous"]').change(function () {
        changeAnonymousOption($(this).prop('checked'));
    });

    $('[name="limitChoice"]').change(function () {
        changeLimitChoice($(this).prop('checked'));
    });

    $('[name="reminder"]').change(function () {
        changeReminder($(this).prop('checked'));
    });

    $('[name="poll.choiceType"]').change(function () {
        changeChoiceType($(this).val());
    });

    $('[name="poll.pollType"]').change(function () {
        changePollType($(this).val());
    });

    $('[name="poll.voteCountingType"][value="' + datas['voteCountingType'] + '"]').attr('checked', 'checked');

    // before loading all choices let's hide everything, it will be shown later
    $('.choices').addClass('hidden');

    prepareChoices('choicesTEXT', 'textChoice_');
    prepareChoices('choicesDATE', 'dateChoice_');
    prepareChoices('choicesIMAGE', 'imageChoice_');
    prepareVotingLists('votingListRESTRICTED');
    prepareVotingLists('votingListGROUP');

    changeChoiceAddAllowed(datas['choiceAddAllowed'] == 'true');
    changeLimitChoice(datas['limitChoice'] == 'true');
    changeReminder(datas['reminder'] == 'true');
    changeAnonymousOption(datas['anonymousOption'] == 'true');

    changeChoiceType(datas['choiceType']);

    changePollType(datas['pollType']);

    $('img[src$="tooltip.png"]').addClass("tooltip");
    $('.tooltip').tipTip({ defaultPosition:'top' });
});
