/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.ui.actions.poll.vote;

import com.google.common.base.Charsets;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.interceptor.ParameterAware;
import org.chorem.pollen.PollenTechnicalException;
import org.chorem.pollen.bean.PollUrl;
import org.chorem.pollen.business.persistence.Choice;
import org.chorem.pollen.business.persistence.ChoiceType;
import org.chorem.pollen.business.persistence.Comment;
import org.chorem.pollen.business.persistence.Poll;
import org.chorem.pollen.business.persistence.PollAccount;
import org.chorem.pollen.business.persistence.PollCommentVisibility;
import org.chorem.pollen.business.persistence.PollType;
import org.chorem.pollen.business.persistence.PollVoteVisibility;
import org.chorem.pollen.business.persistence.UserAccount;
import org.chorem.pollen.business.persistence.Vote;
import org.chorem.pollen.business.persistence.VoteToChoice;
import org.chorem.pollen.services.exceptions.PollAccountNotFound;
import org.chorem.pollen.services.exceptions.PollNotFoundException;
import org.chorem.pollen.ui.PollenUIUtils;
import org.chorem.pollen.ui.actions.PageSkin;
import org.chorem.pollen.ui.actions.PollUriAware;
import org.chorem.pollen.ui.actions.PollenActionSupport;
import org.chorem.pollen.ui.actions.PollenUserSecurityAware;
import org.chorem.pollen.votecounting.VoteCounting;
import org.chorem.pollen.votecounting.model.ChoiceScore;
import org.chorem.pollen.votecounting.model.VoteCountingResult;

public abstract class AbstractVoteAction
extends PollenActionSupport
implements ParameterAware,
PollUriAware,
PollenUserSecurityAware {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(AbstractVoteAction.class);
    public static final String PREPARE_VOTE_PAGE = "prepareVotePage";
    private Poll poll;
    private boolean feedFileExisting;
    private PollAccount pollAccount;
    private List<Vote> votes;
    private Vote vote;
    private String commentAuthor;
    List<ChoiceScore> results;
    private List<Comment> comments;

    protected AbstractVoteAction() {
        super(PageSkin.VOTE);
    }

    public abstract boolean isModerate();

    public Poll getPoll() {
        return this.poll;
    }

    public PollAccount getPollAccount() {
        return this.pollAccount;
    }

    public List<Vote> getVotes() {
        return this.votes;
    }

    public Vote getVote() {
        return this.vote;
    }

    public List<ChoiceScore> getResults() {
        return this.results;
    }

    public List<Comment> getComments() {
        return this.comments;
    }

    public String getVoteSizeMessage() {
        String result = PollenUIUtils.getVoteSizeMessage((Poll)this.getPoll(), (Locale)this.getLocale());
        return result;
    }

    public String getVoteCountingTypeName() {
        VoteCounting voteCounting = this.getVoteCounting(this.getPoll());
        String result = voteCounting.getName(this.getLocale());
        return result;
    }

    public String getVoteCountingTypeHelp() {
        VoteCounting voteCounting = this.getVoteCounting(this.getPoll());
        String result = voteCounting.getShortHelp(this.getLocale());
        return result;
    }

    public String getPollVoteVisibilityName() {
        PollVoteVisibility strategy = this.getPoll().getPollVoteVisibility();
        String result = this._(strategy.getI18nKey(), new Object[0]);
        return result;
    }

    public String getPollVoteVisibilityHelp() {
        PollVoteVisibility strategy = this.getPoll().getPollVoteVisibility();
        String result = this._(strategy.getI18nHelpKey(), new Object[0]);
        return result;
    }

    public boolean isCommentAllowed() {
        PollCommentVisibility pollCommentVisibility = this.getPoll().getPollCommentVisibility();
        return pollCommentVisibility == PollCommentVisibility.EVERYBODY;
    }

    public boolean isChoiceInVote(VoteToChoice choice) {
        VoteCounting voteCounting = this.getVoteCounting(this.getPoll());
        boolean result = voteCounting.isChoiceInVote(choice.getVoteValue());
        return result;
    }

    public String getChoiceValue(VoteToChoice choice) {
        VoteCounting voteCounting = this.getVoteCounting(this.getPoll());
        String result = voteCounting.getDisplayVoteValue(choice.getVoteValue());
        return result;
    }

    public String getCommentAuthor() {
        if (this.commentAuthor == null) {
            UserAccount user = this.getUserSecurityContext().getUserAccount();
            this.commentAuthor = user == null ? this.getPollAccount().getVotingId() : user.getDisplayName();
        }
        return this.commentAuthor;
    }

    public String getSummaryUrl() {
        PollUrl url = this.getPollUrlService().getPollSummaryUrl(this.poll);
        url.getPollUri().setAccountId(this.getUserSecurityContext().getAccountId());
        return url.getUrl();
    }

    public String getResultUrl() {
        PollUrl url = this.getPollUrlService().getPollResultUrl(this.poll);
        url.getPollUri().setAccountId(this.getUserSecurityContext().getAccountId());
        this.getUserSecurityContext().removeAccountIdWhenConnected(url);
        return url.getUrl();
    }

    public String getVoteMessages() {
        return this._("pollen.common.voteNbVotes", new Object[]{this.poll.sizeVote()});
    }

    public boolean isFeedFileExisting() {
        return this.feedFileExisting;
    }

    public boolean isCreatorOrAdmin() {
        return this.getUserSecurityContext().isCreator() || this.getUserSecurityContext().isAdmin();
    }

    public boolean isAccountFieldDisplayed() {
        return !this.poll.isAnonymous() || this.isRestrictedPoll() || this.isGroupPoll();
    }

    public boolean isPollChoiceOrVoteStarted() {
        Date now = this.serviceContext.getCurrentTime();
        return this.poll.isAddChoiceStarted(now) || this.poll.isStarted(now);
    }

    public boolean isAnonymousVote() {
        PollVoteVisibility pollVoteVisibility = this.poll.getPollVoteVisibility();
        return pollVoteVisibility == PollVoteVisibility.NOBODY;
    }

    public boolean isPollChoiceRunning() {
        Date now = this.serviceContext.getCurrentTime();
        return this.poll.isAddChoiceRunning(now);
    }

    public boolean isPollStarted() {
        Date now = this.serviceContext.getCurrentTime();
        return this.poll.getBeginDate() == null || this.poll.getBeginDate().before(now);
    }

    public boolean isPollFinished() {
        Date now = this.serviceContext.getCurrentTime();
        return this.poll.getEndDate() != null && this.poll.getEndDate().before(now);
    }

    public boolean isDescNull(Choice choice) {
        return StringUtils.isEmpty((CharSequence)choice.getDescription());
    }

    public boolean isFreePoll() {
        return this.poll.isPollFree();
    }

    public boolean isRestrictedPoll() {
        return this.poll.getPollType() == PollType.RESTRICTED;
    }

    public boolean isGroupPoll() {
        return this.poll.getPollType() == PollType.GROUP;
    }

    public boolean isTextType() {
        return this.poll.getChoiceType() == ChoiceType.TEXT;
    }

    public boolean isDateType() {
        return this.poll.getChoiceType() == ChoiceType.DATE;
    }

    public boolean isImageType() {
        return this.poll.getChoiceType() == ChoiceType.IMAGE;
    }

    public boolean isVoteAllowed() {
        return !this.isModerate() && this.getSecurityService().isCanVote(this.getUserSecurityContext());
    }

    public boolean isResultAllowed() {
        return this.getSecurityService().isCanAccessResult(this.getUserSecurityContext());
    }

    public String getPollCreatorName() {
        PollAccount creator = this.poll.getCreator();
        String result = creator.getVotingId();
        if (StringUtils.isBlank((CharSequence)result)) {
            result = creator.getEmail();
        }
        if (StringUtils.isBlank((CharSequence)result)) {
            result = this._("pollen.common.undefined", new Object[0]);
        }
        return result;
    }

    public String getPollBeginDate() {
        Date date = this.poll.getBeginDate();
        String result = date == null ? this._("pollen.common.undefined", new Object[0]) : this.getPollService().decorateDate(date);
        return result;
    }

    public String getPollEndDate() {
        Date date = this.poll.getEndDate();
        String result = date == null ? this._("pollen.common.undefined", new Object[0]) : this.getPollService().decorateDate(date);
        return result;
    }

    public boolean isModifyVoteAllowed(Vote vote) {
        return this.getSecurityService().isCanModifyVote(this.getUserSecurityContext(), vote.getTopiaId());
    }

    public boolean isDeleteCommentAllowed(Comment comment) {
        return this.getSecurityService().isCanDeleteComment(this.getUserSecurityContext(), comment);
    }

    public boolean isDeleteVoteAllowed(Vote vote) {
        return this.getSecurityService().isCanDeleteVote(this.getUserSecurityContext(), vote.getTopiaId());
    }

    public String getResultValue(Choice choice) {
        String val = this.getPollVoteCountingService().getResultValue(choice, this.results);
        return val;
    }

    public String getChoiceFragment() {
        VoteCounting voteCounting = this.getVoteCounting(this.poll);
        String result = "displayVote_" + voteCounting.getVoteValueEditorType().name() + ".jsp";
        return result;
    }

    public Date getChoiceAsDate(Choice choice) {
        return new Date(Long.valueOf(choice.getName()));
    }

    public void setCommentAuthor(String commentAuthor) {
        this.commentAuthor = commentAuthor;
    }

    public String prepareVotePage() throws Exception {
        this.loadPoll();
        this.loadPollAccount();
        List allVotes = this.getVoteService().getAllVotes(this.poll);
        this.votes = this.getSecurityService().filterVotes(this.poll, allVotes, this.getUserSecurityContext());
        if (this.isVoteAllowed()) {
            this.vote = this.getVoteService().getVoteEditable(this.poll, this.pollAccount);
        }
        if (this.isResultAllowed()) {
            VoteCountingResult result = this.getPollVoteCountingService().getMainResult(this.poll);
            this.results = result.getScores();
            if (log.isDebugEnabled()) {
                for (ChoiceScore res : this.results) {
                    log.debug((Object)(res.getChoiceId() + ": " + res.getScoreValue()));
                }
            }
        }
        if (this.isCommentAllowed()) {
            this.comments = this.getPollCommentService().getAllComments(this.poll.getPollId());
        }
        this.feedFileExisting = this.getSecurityService().isCanShowFeed(this.getUserSecurityContext());
        if (log.isDebugEnabled()) {
            Date now = this.serviceContext.getCurrentTime();
            log.debug((Object)("pollChoiceOrVoteStarted = " + this.isPollChoiceOrVoteStarted()));
            log.debug((Object)("pollChoiceRunning       = " + this.isPollChoiceRunning()));
            log.debug((Object)("pollRunning             = " + this.poll.isRunning(now)));
            log.debug((Object)("creatorOrAdminUser      = " + this.isCreatorOrAdmin()));
            log.debug((Object)("isVoteAllowed           = " + this.isVoteAllowed()));
            log.debug((Object)("isCommentAllowed        = " + this.isCommentAllowed()));
            log.debug((Object)("isResultAllowed         = " + this.isResultAllowed()));
            log.debug((Object)("pollVoteVisibility      = " + this.poll.getPollVoteVisibility()));
        }
        return "input";
    }

    public String escapeLineBreak(String text) {
        return text;
    }

    public String getImageChoiceName(Choice choice) {
        String name = choice.getName();
        try {
            String result = URLEncoder.encode(name, Charsets.UTF_8.name());
            return result;
        }
        catch (UnsupportedEncodingException e) {
            throw new PollenTechnicalException("Could not encode name " + name, (Throwable)e);
        }
    }

    protected void loadPollAccount() throws PollAccountNotFound {
        this.pollAccount = this.getPollService().getPollAccountEditable(this.getUserSecurityContext().getAccountId(), this.getUserSecurityContext().getUserAccount(), this.poll);
    }

    protected void loadPoll() throws PollNotFoundException {
        this.poll = this.getUserSecurityContext().getPoll();
    }
}

