/*
 * #%L
 * Pollen :: UI (struts2)
 * $Id: GetFavoriteListPollAccount.java 3702 2012-09-23 13:48:42Z tchemit $
 * $HeadURL: http://svn.chorem.org/svn/pollen/tags/pollen-1.5.5/pollen-ui-struts2/src/main/java/org/chorem/pollen/ui/actions/json/GetFavoriteListPollAccount.java $
 * %%
 * Copyright (C) 2009 - 2012 CodeLutin, Tony Chemit
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.pollen.ui.actions.json;

import org.chorem.pollen.business.persistence.PollAccount;
import org.chorem.pollen.entities.PollenBinderHelper;
import org.nuiton.util.beans.Binder;

import java.util.Map;

/**
 * Get pagined list of poll accounts of a given favorite list.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 1.3
 */
public class GetFavoriteListPollAccount extends AbstractJSONSimpleAction {

    private static final long serialVersionUID = 1L;

    private String pollAccountId;

    private transient Map<String, Object> data;

    public String getPollAccountId() {
        return pollAccountId;
    }

    public void setPollAccountId(String pollAccountId) {
        this.pollAccountId = pollAccountId;
    }

    @Override
    public Map<String, Object> getData() {
        return data;
    }

    @Override
    public String execute() throws Exception {

        PollAccount userAccount =
                getUserService().getEntityById(PollAccount.class, pollAccountId);

        Binder<PollAccount, PollAccount> binder =
                PollenBinderHelper.getSimpleTopiaBinder(PollAccount.class);
        data = binder.obtainProperties(
                userAccount,
                PollAccount.PROPERTY_VOTING_ID,
                PollAccount.PROPERTY_EMAIL
        );
        data.put("id", userAccount.getTopiaId());

        return SUCCESS;
    }
}
