/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.services.service;

import java.lang.management.ManagementFactory;
import java.nio.charset.Charset;
import java.time.Duration;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.util.List;
import org.chorem.pollen.services.UnitHuman;
import org.chorem.pollen.services.bean.health.AppStatus;
import org.chorem.pollen.services.bean.health.PersistenceStatus;
import org.chorem.pollen.services.bean.health.PollenStatus;
import org.chorem.pollen.services.bean.health.RuntimeStatus;
import org.chorem.pollen.services.service.PollenServiceSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HealthService
extends PollenServiceSupport {
    private static final Logger log = LoggerFactory.getLogger(HealthService.class);
    private static final OffsetDateTime RUNNING_SINCE = OffsetDateTime.now();

    public PollenStatus pollenStatus() {
        AppStatus appStatus = this.appStatus();
        RuntimeStatus runtime = HealthService.runtimeStatus();
        PersistenceStatus persistence = this.persistenceStatus();
        return new PollenStatus(appStatus, runtime, persistence);
    }

    public PersistenceStatus persistenceStatus() {
        try {
            long nbPolls = this.getPollDao().count();
            return new PersistenceStatus(nbPolls, List.of());
        }
        catch (Exception eee) {
            if (log.isWarnEnabled()) {
                log.warn("Erreur lors de la lecture du nombre de sondages", (Throwable)eee);
            }
            return new PersistenceStatus(-1L, List.of(eee.getMessage()));
        }
    }

    public AppStatus appStatus() {
        return new AppStatus(this.getPollenServiceConfig().getVersion(), this.getPollenServiceConfig().getCommitId(), this.getPollenServiceConfig().getBuildDate());
    }

    public static RuntimeStatus runtimeStatus() {
        Runtime runtime = Runtime.getRuntime();
        long freeMemoryOnAllocated = runtime.freeMemory();
        long totalMemory = runtime.totalMemory();
        long maxMemory = runtime.maxMemory();
        long usedMemory = totalMemory - freeMemoryOnAllocated;
        double usedPercent = (double)usedMemory / (double)maxMemory * 100.0;
        long freeMemory = maxMemory - usedMemory;
        double freePercent = 100.0 - usedPercent;
        return new RuntimeStatus(System.getProperty("java.vm.name"), System.getProperty("java.version"), Runtime.getRuntime().availableProcessors(), ManagementFactory.getOperatingSystemMXBean().getSystemLoadAverage(), UnitHuman.toHumanString(totalMemory, "o"), String.format("%s (%.2f%s)", UnitHuman.toHumanString(usedMemory, "o"), usedPercent, "%"), String.format("%s (%.2f%s)", UnitHuman.toHumanString(freeMemory, "o"), freePercent, "%"), UnitHuman.toHumanString(maxMemory, "o"), Charset.defaultCharset(), ZoneId.systemDefault(), RUNNING_SINCE, Duration.between(RUNNING_SINCE, OffsetDateTime.now()).toString());
    }
}

