/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.business.migration;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.H2Dialect;
import org.hibernate.dialect.PostgreSQLDialect;
import org.nuiton.topia.migration.DatabaseManager;
import org.nuiton.topia.migration.callback.MigrationCallbackHandler;
import org.nuiton.util.VersionUtil;

public class PollenMigrationCallbackHandler
implements MigrationCallbackHandler {
    private static final Log log = LogFactory.getLog(PollenMigrationCallbackHandler.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MigrationCallbackHandler.MigrationChoice doMigration(DatabaseManager dbManager, String dbVersion, String applicationVersion) {
        if (log.isInfoEnabled()) {
            log.info((Object)("Migration : version de la base : " + dbVersion + ", version de l'application : " + applicationVersion));
        }
        Dialect dialect = dbManager.getDbConfiguration().buildSettings().getDialect();
        MigrationCallbackHandler.MigrationChoice result = MigrationCallbackHandler.MigrationChoice.NO_MIGRATION;
        try {
            Connection conn = dbManager.getConnection();
            try {
                conn.setAutoCommit(false);
                if (VersionUtil.valueOf((String)dbVersion).before(VersionUtil.valueOf((String)"1.1"))) {
                    this.migrateTo1_1(conn, dialect);
                }
                conn.commit();
                result = MigrationCallbackHandler.MigrationChoice.CUSTOM_MIGRATION;
            }
            catch (Exception eee) {
                log.error((Object)"Migration impossible de la base", (Throwable)eee);
                conn.rollback();
            }
            finally {
                conn.close();
            }
        }
        catch (Exception eee) {
            log.error((Object)"Erreur lors de la tentative de migration", (Throwable)eee);
        }
        return result;
    }

    private void migrateTo1_1(Connection conn, Dialect dialect) throws SQLException {
        log.info((Object)"Migrate to version 1_1");
        String[] sqls = null;
        if (dialect instanceof PostgreSQLDialect) {
            sqls = new String[]{"alter table useraccount rename langage to language;", "alter table pollaccount add accountid varchar;", "update pollaccount set accountid=md5(topiaid);", "alter table persontolist drop column hasvoted;", "alter table persontolist add hasvoted boolean default false;", "alter table vote add anonymous boolean default false;", "alter table preventrule add active boolean default true;", "alter table preventrule add onetime boolean default false;"};
        } else if (dialect instanceof H2Dialect) {
            sqls = new String[]{"alter table useraccount alter column langage rename to language;", "alter table pollaccount add accountid varchar;", "update pollaccount set accountid=hash('sha256', stringtoutf8(topiaid), 1000);", "alter table persontolist drop column hasvoted;", "alter table persontolist add hasvoted boolean default false;", "alter table vote add anonymous boolean default false;", "alter table preventrule add active boolean default true;", "alter table preventrule add onetime boolean default false;"};
        } else if (log.isErrorEnabled()) {
            log.error((Object)("Migration non prise en charge pour ce type de dialect : " + dialect));
        }
        for (void var7_7 : sqls) {
            log.info((Object)("try " + (String)var7_7));
            PreparedStatement sta = conn.prepareStatement((String)var7_7);
            sta.executeUpdate();
            log.info((Object)("done " + (String)var7_7));
        }
    }
}

