/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.lima.ui.vatchart;

import java.util.List;
import javax.swing.tree.TreePath;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.business.api.VatStatementService;
import org.chorem.lima.business.exceptions.AlreadyExistVatStatementException;
import org.chorem.lima.business.exceptions.NotAllowedLabelException;
import org.chorem.lima.entity.VatStatement;
import org.chorem.lima.entity.VatStatementImpl;
import org.chorem.lima.service.LimaServiceFactory;
import org.chorem.lima.ui.vatchart.VatChartViewHandler;
import org.chorem.lima.util.ErrorHelper;
import org.jdesktop.swingx.treetable.AbstractTreeTableModel;
import org.nuiton.i18n.I18n;

public class VatChartTreeTableModel
extends AbstractTreeTableModel {
    private static final Log log = LogFactory.getLog(VatChartViewHandler.class);
    protected final VatStatementService vatStatementService = (VatStatementService)LimaServiceFactory.getService(VatStatementService.class);
    protected ErrorHelper errorHelper;

    public VatChartTreeTableModel() {
        super((Object)new VatStatementImpl());
    }

    public int getColumnCount() {
        return 2;
    }

    public String getColumnName(int column) {
        String res = null;
        switch (column) {
            case 0: {
                res = I18n.t((String)"lima.table.label", (Object[])new Object[0]);
                break;
            }
            case 1: {
                res = I18n.t((String)"lima.table.account", (Object[])new Object[0]);
            }
        }
        return res;
    }

    public int getChildCount(Object node) {
        int result = 0;
        if (node == this.getRoot()) {
            result = this.vatStatementService.getChildrenVatStatement(null).size();
        } else {
            VatStatement parentVatStatementHeader = (VatStatement)node;
            result = this.vatStatementService.getChildrenVatStatement(parentVatStatementHeader).size();
        }
        return result;
    }

    public Object getChild(Object parent, int index) {
        Object result = null;
        if (parent == this.getRoot()) {
            List vatStatements = this.vatStatementService.getChildrenVatStatement(null);
            result = vatStatements.get(index);
        } else {
            VatStatement parentVatStatement = (VatStatement)parent;
            List vatStatements = this.vatStatementService.getChildrenVatStatement(parentVatStatement);
            result = vatStatements.get(index);
        }
        return result;
    }

    public int getIndexOfChild(Object parent, Object child) {
        int result = 0;
        if (parent == this.getRoot()) {
            List vatStatements = this.vatStatementService.getChildrenVatStatement(null);
            result = vatStatements.indexOf(child);
        } else {
            VatStatement parentVatStatement = (VatStatement)parent;
            List vatStatements = this.vatStatementService.getChildrenVatStatement(parentVatStatement);
            result = vatStatements.indexOf(child);
        }
        return result;
    }

    public Object getValueAt(Object node, int column) {
        String result = "n/a";
        VatStatement vatStatement = (VatStatement)node;
        switch (column) {
            case 0: {
                result = vatStatement.getLabel();
                break;
            }
            case 1: {
                result = vatStatement.getAccounts();
            }
        }
        return result;
    }

    public boolean isCellEditable(Object node, int column) {
        return column == 1 && this.isLeaf(node);
    }

    public boolean isLeaf(Object node) {
        return this.getChildCount(node) == 0;
    }

    public void refreshTree() {
        this.modelSupport.fireNewRoot();
    }

    public void addVatStatement(TreePath path, VatStatement vatStatement) {
        VatStatement parentVatStatementHeader = null;
        if (path != null) {
            parentVatStatementHeader = (VatStatement)path.getLastPathComponent();
        }
        try {
            this.vatStatementService.createVatStatement(parentVatStatementHeader, vatStatement);
        }
        catch (AlreadyExistVatStatementException alreadyExistVatStatement) {
            this.errorHelper.showErrorMessage(I18n.t((String)"lima.financialStatement.error.alreadyExistFinancialStatement", (Object[])new Object[]{alreadyExistVatStatement.getVatStatementLabel(), alreadyExistVatStatement.getMasterLabel()}));
        }
        catch (NotAllowedLabelException notAllowedLabel) {
            this.errorHelper.showErrorMessage(I18n.t((String)"lima.error.notAllowedLabel", (Object[])new Object[]{notAllowedLabel.getLabel()}));
        }
        this.modelSupport.fireTreeStructureChanged(path);
    }

    public void updateVatStatement(TreePath path, VatStatement vatStatement) {
        this.vatStatementService.updateVatStatement(vatStatement);
        this.modelSupport.fireTreeStructureChanged(path);
    }

    public void removeVatStatementObject(TreePath path, VatStatement vatStatement) {
        int index = this.getIndexOfChild(path.getParentPath().getLastPathComponent(), vatStatement);
        this.vatStatementService.removeVatStatement(vatStatement);
        this.modelSupport.fireChildRemoved(path.getParentPath(), index, (Object)vatStatement);
    }

    public void setValueAt(Object value, Object node, int column) {
        VatStatement vatStatement = (VatStatement)node;
        vatStatement.setAccounts((String)value);
        this.vatStatementService.updateVatStatement(vatStatement);
    }
}

