/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.lima.ui.home;

import java.util.List;
import javax.swing.event.HyperlinkEvent;
import jaxx.runtime.JAXXContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.LimaSwingApplicationContext;
import org.chorem.lima.business.ServiceListener;
import org.chorem.lima.business.api.FiscalPeriodService;
import org.chorem.lima.business.api.ImportService;
import org.chorem.lima.service.LimaServiceFactory;
import org.chorem.lima.ui.MainView;
import org.chorem.lima.ui.home.AbstractHomePane;
import org.chorem.lima.ui.home.HomeView;
import org.nuiton.i18n.I18n;

public class FiscalYearsPane
extends AbstractHomePane
implements ServiceListener {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(FiscalYearsPane.class);
    protected FiscalPeriodService fiscalPeriodService = (FiscalPeriodService)LimaServiceFactory.getService(FiscalPeriodService.class);

    public FiscalYearsPane(HomeView view) {
        super(view);
        LimaServiceFactory.addServiceListener(FiscalPeriodService.class, (ServiceListener)this);
        LimaServiceFactory.addServiceListener(ImportService.class, (ServiceListener)this);
        this.refresh();
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent e) {
        if (HyperlinkEvent.EventType.ACTIVATED.equals(e.getEventType()) && e.getDescription().equals("#fiscalperiodschart")) {
            MainView ui = (MainView)LimaSwingApplicationContext.MAIN_UI_ENTRY_DEF.getContextValue((JAXXContext)this.view);
            ui.getHandler().showFiscalPeriodView((JAXXContext)ui);
        }
    }

    public void refresh() {
        log.debug((Object)"Rafra\u00eechissement fiscal periods pane");
        String htmlBegin = "<font face='sans-serif' size=3><p style=vertical-align:'bottom', horizontal-align:'center'>";
        String htmlEnd = "</p></font>";
        List fiscalPeriods = this.fiscalPeriodService.getAllFiscalPeriods();
        List unblockedFiscalPeriods = this.fiscalPeriodService.getAllUnblockedFiscalPeriods();
        if (unblockedFiscalPeriods.size() > 0) {
            this.setBackground(GREEN_BACKGROUND);
            String fiscalString = I18n.t((String)"lima.home.fiscalYears.opened", (Object[])new Object[]{unblockedFiscalPeriods.size()}) + "<br/>" + I18n.t((String)"lima.home.fiscalYears.closed", (Object[])new Object[]{fiscalPeriods.size() - unblockedFiscalPeriods.size()}) + "<br/><br/><a href='#fiscalperiodschart'>" + I18n.t((String)"lima.home.fiscalYears.modify", (Object[])new Object[0]) + "</a>";
            this.setText(htmlBegin + fiscalString + htmlEnd);
        } else {
            this.setBackground(RED_BACKGROUND);
            String fiscalString = I18n.t((String)"lima.home.fiscalYears.noOpen", (Object[])new Object[0]);
            if (fiscalPeriods.size() > 0) {
                fiscalString = fiscalString + "<br/>" + I18n.t((String)"lima.home.fiscalYears.closed", (Object[])new Object[]{fiscalPeriods.size()});
            }
            fiscalString = fiscalString + "<br/><br/><a href='#fiscalperiodschart'>" + I18n.t((String)"lima.home.fiscalYears.create", (Object[])new Object[0]) + "</a>";
            this.setText(htmlBegin + fiscalString + htmlEnd);
        }
    }

    public void notifyMethod(String serviceName, String methodeName) {
        log.debug((Object)("Nom de la m\u00e9thode : " + methodeName));
        if (methodeName.contains("FiscalPeriod") || methodeName.contains("importAll") || methodeName.contains("importAs")) {
            this.refresh();
        }
    }
}

