/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.lima.ui.financialstatementchart;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JOptionPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.tree.TreePath;
import jaxx.runtime.JAXXContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.business.ServiceListener;
import org.chorem.lima.business.api.FinancialStatementService;
import org.chorem.lima.business.api.ImportService;
import org.chorem.lima.entity.Account;
import org.chorem.lima.entity.FinancialStatement;
import org.chorem.lima.entity.FinancialStatementImpl;
import org.chorem.lima.enums.FinancialStatementsChartEnum;
import org.chorem.lima.enums.ImportExportEnum;
import org.chorem.lima.service.LimaServiceFactory;
import org.chorem.lima.ui.financialstatementchart.FinancialStatementChartTreeTable;
import org.chorem.lima.ui.financialstatementchart.FinancialStatementChartTreeTableModel;
import org.chorem.lima.ui.financialstatementchart.FinancialStatementChartView;
import org.chorem.lima.ui.financialstatementchart.FinancialStatementHeaderForm;
import org.chorem.lima.ui.financialstatementchart.FinancialStatementImportForm;
import org.chorem.lima.ui.financialstatementchart.FinancialStatementMovementForm;
import org.chorem.lima.ui.importexport.ImportExport;
import org.chorem.lima.util.ReportDialogView;
import org.nuiton.i18n.I18n;
import org.nuiton.util.Resource;

public class FinancialStatementChartViewHandler
implements ServiceListener {
    private static final Log log = LogFactory.getLog(FinancialStatementChartViewHandler.class);
    protected FinancialStatementService financialStatementService;
    protected FinancialStatementChartView view;

    protected FinancialStatementChartViewHandler(FinancialStatementChartView view) {
        this.view = view;
        this.financialStatementService = (FinancialStatementService)LimaServiceFactory.getService(FinancialStatementService.class);
        LimaServiceFactory.addServiceListener(ImportService.class, (ServiceListener)this);
        this.init();
    }

    public void init() {
        InputMap inputMap = this.view.getInputMap(1);
        ActionMap actionMap = this.view.getActionMap();
        String binding = "add-FinancialStatementHeader";
        inputMap.put(KeyStroke.getKeyStroke(78, 192), binding);
        actionMap.put(binding, new AbstractAction(){
            private static final long serialVersionUID = -7788186392450704736L;

            @Override
            public void actionPerformed(ActionEvent e) {
                FinancialStatementChartViewHandler.this.addFinancialStatementHeader();
            }
        });
        binding = "add-FinancialStatementMovement";
        inputMap.put(KeyStroke.getKeyStroke(78, 128), binding);
        actionMap.put(binding, new AbstractAction(){
            private static final long serialVersionUID = -2024337652917520114L;

            @Override
            public void actionPerformed(ActionEvent e) {
                FinancialStatementChartViewHandler.this.addFinancialStatementMovement();
            }
        });
        binding = "update-FinancialStatement";
        inputMap.put(KeyStroke.getKeyStroke(77, 128), binding);
        actionMap.put(binding, new AbstractAction(){
            private static final long serialVersionUID = 38900830693943289L;

            @Override
            public void actionPerformed(ActionEvent e) {
                FinancialStatementChartViewHandler.this.updateFinancialStatement();
            }
        });
        binding = "remove-FinancialStatement";
        inputMap.put(KeyStroke.getKeyStroke(127, 0), binding);
        actionMap.put(binding, new AbstractAction(){
            private static final long serialVersionUID = 5281128699359433458L;

            @Override
            public void actionPerformed(ActionEvent e) {
                FinancialStatementChartViewHandler.this.removeFinancialStatement();
            }
        });
        binding = "import-FinancialStatement";
        inputMap.put(KeyStroke.getKeyStroke(73, 128), binding);
        actionMap.put(binding, new AbstractAction(){
            private static final long serialVersionUID = -8953401784332356894L;

            @Override
            public void actionPerformed(ActionEvent e) {
                FinancialStatementChartViewHandler.this.importFinancialStatementChart();
            }
        });
        binding = "check-FinancialStatement";
        inputMap.put(KeyStroke.getKeyStroke(75, 128), binding);
        actionMap.put(binding, new AbstractAction(){
            private static final long serialVersionUID = 4940041938090472686L;

            @Override
            public void actionPerformed(ActionEvent e) {
                FinancialStatementChartViewHandler.this.financialStatementChartCheck();
            }
        });
    }

    public void addFinancialStatementHeader() {
        FinancialStatementChartTreeTable treeTable = this.view.getTreeTable();
        FinancialStatementChartTreeTableModel treeTableModel = (FinancialStatementChartTreeTableModel)treeTable.getTreeTableModel();
        FinancialStatementImpl newFinancialStatementHeader = new FinancialStatementImpl();
        final FinancialStatementHeaderForm financialStatementHeaderForm = new FinancialStatementHeaderForm((JAXXContext)this.view);
        financialStatementHeaderForm.setFinancialStatement((FinancialStatement)newFinancialStatementHeader);
        InputMap inputMap = financialStatementHeaderForm.getRootPane().getInputMap(1);
        ActionMap actionMap = financialStatementHeaderForm.getRootPane().getActionMap();
        String binding = "dispose";
        inputMap.put(KeyStroke.getKeyStroke(27, 0), binding);
        actionMap.put(binding, new AbstractAction(){
            private static final long serialVersionUID = 743244863218861378L;

            @Override
            public void actionPerformed(ActionEvent e) {
                financialStatementHeaderForm.performCancel();
            }
        });
        financialStatementHeaderForm.setLocationRelativeTo(this.view);
        financialStatementHeaderForm.setVisible(true);
        newFinancialStatementHeader = financialStatementHeaderForm.getFinancialStatement();
        if (newFinancialStatementHeader != null) {
            newFinancialStatementHeader.setHeader(true);
            int selectedRow = treeTable.getSelectedRow();
            TreePath treePath = selectedRow != -1 ? treeTable.getPathForRow(selectedRow) : new TreePath(treeTableModel.getRoot());
            treeTableModel.addFinancialStatement(treePath, (FinancialStatement)newFinancialStatementHeader);
        }
    }

    public void addFinancialStatementMovement() {
        FinancialStatementChartTreeTable treeTable = this.view.getTreeTable();
        FinancialStatementChartTreeTableModel treeTableModel = (FinancialStatementChartTreeTableModel)treeTable.getTreeTableModel();
        FinancialStatementImpl newFinancialStatementMovement = new FinancialStatementImpl();
        final FinancialStatementMovementForm financialStatementMovementForm = new FinancialStatementMovementForm((JAXXContext)this.view);
        financialStatementMovementForm.setFinancialStatement((FinancialStatement)newFinancialStatementMovement);
        InputMap inputMap = financialStatementMovementForm.getRootPane().getInputMap(1);
        ActionMap actionMap = financialStatementMovementForm.getRootPane().getActionMap();
        String binding = "dispose";
        inputMap.put(KeyStroke.getKeyStroke(27, 0), binding);
        actionMap.put(binding, new AbstractAction(){
            private static final long serialVersionUID = 4247772767239546785L;

            @Override
            public void actionPerformed(ActionEvent e) {
                financialStatementMovementForm.performCancel();
            }
        });
        financialStatementMovementForm.setLocationRelativeTo(this.view);
        financialStatementMovementForm.setVisible(true);
        newFinancialStatementMovement = financialStatementMovementForm.getFinancialStatement();
        if (newFinancialStatementMovement != null) {
            int selectedRow = this.view.treeTable.getSelectedRow();
            TreePath treePath = this.view.treeTable.getPathForRow(selectedRow);
            treeTableModel.addFinancialStatement(treePath, (FinancialStatement)newFinancialStatementMovement);
        }
    }

    public void updateFinancialStatement() {
        FinancialStatementChartTreeTable treeTable = this.view.getTreeTable();
        FinancialStatementChartTreeTableModel treeTableModel = (FinancialStatementChartTreeTableModel)treeTable.getTreeTableModel();
        int selectedRow = this.view.treeTable.getSelectedRow();
        TreePath treePath = this.view.treeTable.getPathForRow(selectedRow);
        FinancialStatement financialStatement = (FinancialStatement)treePath.getLastPathComponent();
        if (financialStatement != null) {
            treePath = selectedRow != -1 ? this.view.treeTable.getPathForRow(selectedRow) : new TreePath(treeTableModel.getRoot());
            log.debug((Object)financialStatement.isHeader());
            if (financialStatement.isHeader()) {
                final FinancialStatementHeaderForm financialStatementHeaderForm = new FinancialStatementHeaderForm((JAXXContext)this.view);
                financialStatementHeaderForm.setFinancialStatement(financialStatement);
                InputMap inputMap = financialStatementHeaderForm.getRootPane().getInputMap(1);
                ActionMap actionMap = financialStatementHeaderForm.getRootPane().getActionMap();
                String binding = "dispose";
                inputMap.put(KeyStroke.getKeyStroke(27, 0), binding);
                actionMap.put(binding, new AbstractAction(){
                    private static final long serialVersionUID = 3175340724715264379L;

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        financialStatementHeaderForm.performCancel();
                    }
                });
                financialStatementHeaderForm.setLocationRelativeTo(this.view);
                financialStatementHeaderForm.setVisible(true);
                financialStatement = financialStatementHeaderForm.getFinancialStatement();
            } else {
                final FinancialStatementMovementForm financialStatementMovementForm = new FinancialStatementMovementForm((JAXXContext)this.view);
                financialStatementMovementForm.setFinancialStatement(financialStatement);
                InputMap inputMap = financialStatementMovementForm.getRootPane().getInputMap(1);
                ActionMap actionMap = financialStatementMovementForm.getRootPane().getActionMap();
                String binding = "dispose";
                inputMap.put(KeyStroke.getKeyStroke(27, 0), binding);
                actionMap.put(binding, new AbstractAction(){
                    private static final long serialVersionUID = -3722767598494135172L;

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        financialStatementMovementForm.performCancel();
                    }
                });
                financialStatementMovementForm.setLocationRelativeTo(this.view);
                financialStatementMovementForm.setVisible(true);
                financialStatement = financialStatementMovementForm.getFinancialStatement();
            }
            if (financialStatement != null) {
                treeTableModel.updateFinancialStatement(treePath, financialStatement);
            }
        }
    }

    public void removeFinancialStatement() {
        int n;
        FinancialStatementChartTreeTable treeTable = this.view.getTreeTable();
        FinancialStatementChartTreeTableModel treeTableModel = (FinancialStatementChartTreeTableModel)treeTable.getTreeTableModel();
        int selectedRow = this.view.treeTable.getSelectedRow();
        if (selectedRow != -1 && (n = JOptionPane.showConfirmDialog(this.view, I18n.t((String)"lima.financialStatement.remove.confirm", (Object[])new Object[0]), I18n.t((String)"lima.confirmation", (Object[])new Object[0]), 0, 3)) == 0) {
            TreePath treePath = this.view.treeTable.getPathForRow(selectedRow);
            FinancialStatement financialStatement = (FinancialStatement)treePath.getLastPathComponent();
            treeTableModel.removeFinancialStatementObject(treePath, financialStatement);
        }
    }

    public void refresh() {
        FinancialStatementChartTreeTable treeTable = this.view.getTreeTable();
        FinancialStatementChartTreeTableModel treeTableModel = (FinancialStatementChartTreeTableModel)treeTable.getTreeTableModel();
        treeTableModel.refreshTree();
        this.view.repaint();
    }

    public void importFinancialStatementChart() {
        final FinancialStatementImportForm form = new FinancialStatementImportForm();
        InputMap inputMap = form.getRootPane().getInputMap(1);
        ActionMap actionMap = form.getRootPane().getActionMap();
        String binding = "dispose";
        inputMap.put(KeyStroke.getKeyStroke(27, 0), binding);
        actionMap.put(binding, new AbstractAction(){
            private static final long serialVersionUID = -8291208693591479867L;

            @Override
            public void actionPerformed(ActionEvent e) {
                form.performCancel();
            }
        });
        form.setLocationRelativeTo(this.view);
        form.setVisible(true);
        Object value = form.getRadioButtons().getSelectedValue();
        if (value != null) {
            if (form.getDeleteFinancialStatementChart().isSelected()) {
                this.financialStatementService.removeAllFinancialStatement();
            }
            FinancialStatementsChartEnum defaultFinancialStatementsEnum = (FinancialStatementsChartEnum)((Object)value);
            ImportExport importExport = new ImportExport(this.view);
            importExport.importExport(ImportExportEnum.CSV_FINANCIALSTATEMENTS_IMPORT, defaultFinancialStatementsEnum.getFilePath(), true);
        }
    }

    public void financialStatementChartCheck() {
        List unusedAccounts = this.financialStatementService.checkFinancialStatementChart();
        StringBuilder result = new StringBuilder(I18n.t((String)"lima.financialStatements.check.warn", (Object[])new Object[0]) + "\n\n");
        for (Account account : unusedAccounts) {
            result.append(I18n.t((String)"lima.financialStatements.check.nothing", (Object[])new Object[]{account.getAccountNumber(), account.getLabel()}) + "\n");
        }
        this.showReportDialog(result.toString(), I18n.t((String)"lima.financialStatements.check", (Object[])new Object[0]), this.view);
    }

    public void showReportDialog(String message, String title, Component parent) {
        ReportDialogView reportDialogView = new ReportDialogView();
        reportDialogView.setIconImage(Resource.getIcon((String)"icons/lima.png").getImage());
        JTextArea textArea = reportDialogView.getTextArea();
        textArea.setText(message);
        reportDialogView.setSize(600, 400);
        reportDialogView.setTitle(title);
        reportDialogView.setLocationRelativeTo(parent);
        reportDialogView.setVisible(true);
    }

    public void notifyMethod(String serviceName, String methodName) {
        if (methodName.contains("FinancialStatements") || methodName.contains("importAll") || methodName.contains("importAs")) {
            this.refresh();
        }
    }
}

