/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.lima.ui.common;

import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import org.chorem.lima.LimaSwingConfig;
import org.chorem.lima.ui.common.Column;
import org.chorem.lima.util.ErrorHelper;
import org.nuiton.i18n.I18n;

public abstract class AbstractLimaTableModel<E>
extends AbstractTableModel {
    private static final long serialVersionUID = -1125159257823536360L;
    protected List<E> values = Lists.newArrayList();
    protected List<Column<AbstractLimaTableModel<E>>> columns = Lists.newArrayList();
    protected Comparator<E> comparator;
    protected ErrorHelper errorHelper = new ErrorHelper(LimaSwingConfig.getInstance());

    public AbstractLimaTableModel() {
        this.initColumn();
    }

    protected abstract void initColumn();

    public void setComparator(Comparator<E> comparator) {
        this.comparator = comparator;
    }

    public void sort() {
        if (this.comparator != null) {
            Collections.sort(this.values, this.comparator);
            this.fireTableDataChanged();
        }
    }

    public void setValues(Collection<E> values) {
        this.values.clear();
        this.values.addAll(values);
        this.sort();
        this.fireTableDataChanged();
    }

    public void setValue(int row, E value) {
        this.values.set(row, value);
        this.fireTableRowsUpdated(row, row);
    }

    public void addValue(E value) {
        int row = this.values.size();
        this.values.add(value);
        this.fireTableRowsInserted(row, row);
        this.sort();
    }

    public void addAll(Collection<E> values) {
        if (values != null && !values.isEmpty()) {
            int row = this.values.size();
            this.values.addAll(values);
            this.fireTableRowsInserted(row, row + values.size() - 1);
            this.sort();
        }
    }

    public void clear() {
        if (!this.values.isEmpty()) {
            int rowCount = this.getRowCount();
            this.values.clear();
            this.fireTableRowsDeleted(0, rowCount - 1);
        }
    }

    public List<E> getValues() {
        return this.values;
    }

    public void remove(E value) {
        int row = this.indexOf(value);
        this.values.remove(value);
        this.fireTableRowsDeleted(row, row);
    }

    public void removeAll(Collection<E> values) {
        for (E value : values) {
            this.remove(value);
        }
    }

    public void remove(int row) {
        this.values.remove(row);
        this.fireTableRowsDeleted(row, row);
    }

    public E get(int row) {
        return this.values.get(row);
    }

    public int indexOf(E value) {
        return this.values.indexOf(value);
    }

    public boolean contains(E value) {
        return this.values.contains(value);
    }

    public void addColumn(Column column) {
        column.setTableModel(this);
        this.columns.add(column);
        this.fireTableStructureChanged();
    }

    public Column getColumn(int column) {
        return this.columns.get(column);
    }

    @Override
    public int getColumnCount() {
        return this.columns.size();
    }

    @Override
    public int getRowCount() {
        return this.size();
    }

    public int size() {
        return this.values.size();
    }

    @Override
    public Class<?> getColumnClass(int column) {
        Class<?> result = null;
        if (column >= 0 && column < this.columns.size()) {
            result = this.columns.get(column).getColumnClass();
        }
        return result;
    }

    @Override
    public String getColumnName(int column) {
        String result = I18n.t((String)"lima.noAffect", (Object[])new Object[0]);
        if (column >= 0 && column < this.columns.size()) {
            result = this.columns.get(column).getColumnName();
        }
        return result;
    }

    @Override
    public Object getValueAt(int row, int column) {
        Object result = this.columns.get(column).getValueAt(row);
        return result;
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        boolean result = this.columns.get(column).isCellEditable(row);
        return result;
    }

    @Override
    public void setValueAt(Object value, int row, int column) {
        boolean update = this.columns.get(column).setValueAt(value, row);
        if (update) {
            this.fireTableCellUpdated(row, column);
        }
    }
}

