/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.lima.ui.combobox;

import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.business.ServiceListener;
import org.chorem.lima.business.api.EntryBookService;
import org.chorem.lima.business.api.ImportService;
import org.chorem.lima.entity.EntryBook;
import org.chorem.lima.service.LimaServiceFactory;

public class EntryBookComboBoxModel
extends AbstractListModel
implements ComboBoxModel,
ServiceListener {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(EntryBookComboBoxModel.class);
    protected Object selectedEntryBook;
    protected EntryBookService entryBookService = (EntryBookService)LimaServiceFactory.getService(EntryBookService.class);
    protected List<EntryBook> cacheDatas;

    public EntryBookComboBoxModel() {
        LimaServiceFactory.addServiceListener(EntryBookService.class, (ServiceListener)this);
        LimaServiceFactory.addServiceListener(ImportService.class, (ServiceListener)this);
        this.cacheDatas = this.getDataList();
    }

    @Override
    public int getSize() {
        return this.cacheDatas.size();
    }

    @Override
    public Object getElementAt(int index) {
        return this.cacheDatas.get(index);
    }

    @Override
    public void setSelectedItem(Object anItem) {
        this.selectedEntryBook = anItem;
        this.fireContentsChanged(this, -1, -1);
    }

    @Override
    public Object getSelectedItem() {
        return this.selectedEntryBook;
    }

    public List<EntryBook> getDataList() {
        List result = this.entryBookService.getAllEntryBooks();
        return result;
    }

    public void refresh() {
        this.cacheDatas = this.getDataList();
        this.fireContentsChanged(this, 0, this.cacheDatas.size());
    }

    public void notifyMethod(String serviceName, String methodeName) {
        if (methodeName.contains("EntryBook") || methodeName.contains("importAll")) {
            this.refresh();
        }
    }
}

