/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.lima;

import java.util.Locale;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.context.DefaultApplicationContext;
import jaxx.runtime.context.JAXXContextEntryDef;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.LimaSwingConfig;
import org.chorem.lima.business.LimaServiceConfig;
import org.chorem.lima.ui.LimaDecoratorProvider;
import org.chorem.lima.ui.MainView;
import org.chorem.lima.ui.MainViewHandler;
import org.nuiton.decorator.DecoratorProvider;
import org.nuiton.i18n.I18n;
import org.nuiton.i18n.init.DefaultI18nInitializer;
import org.nuiton.i18n.init.I18nInitializer;
import org.nuiton.util.StringUtil;

public class LimaSwingApplicationContext
extends DefaultApplicationContext {
    private static Log log = LogFactory.getLog(LimaSwingApplicationContext.class);
    protected static LimaSwingApplicationContext instance;
    public static JAXXContextEntryDef<MainView> MAIN_UI_ENTRY_DEF;
    public static JAXXContextEntryDef<DecoratorProvider> DECORATOR_PROVIDER_DEF;
    public static JAXXContextEntryDef<LimaSwingConfig> CONFIG_DEF;

    public static boolean isInit() {
        return instance != null;
    }

    public static LimaSwingApplicationContext init() throws IllegalStateException {
        if (LimaSwingApplicationContext.isInit()) {
            throw new IllegalStateException("there is already a application context registred.");
        }
        instance = new LimaSwingApplicationContext();
        instance.setContextValue(new MainViewHandler());
        CONFIG_DEF.setContextValue((JAXXContext)instance, (Object)LimaSwingConfig.getInstance());
        DECORATOR_PROVIDER_DEF.setContextValue((JAXXContext)instance, (Object)new LimaDecoratorProvider());
        LimaSwingApplicationContext.initApplicationContext();
        return instance;
    }

    protected static void initApplicationContext() {
        LimaServiceConfig.getInstance();
    }

    public static LimaSwingApplicationContext get() throws IllegalStateException {
        if (!LimaSwingApplicationContext.isInit()) {
            throw new IllegalStateException("no application context registred.");
        }
        return instance;
    }

    public LimaSwingConfig getConfig() {
        return (LimaSwingConfig)((Object)CONFIG_DEF.getContextValue((JAXXContext)this));
    }

    public DecoratorProvider getDecoratorProvider() {
        return (DecoratorProvider)DECORATOR_PROVIDER_DEF.getContextValue((JAXXContext)this);
    }

    public void initI18n(LimaSwingConfig config) {
        I18n.close();
        DefaultI18nInitializer i18nInitializer = new DefaultI18nInitializer("lima");
        Locale locale = config.getLocale();
        I18n.init((I18nInitializer)i18nInitializer, (Locale)locale);
        Locale.setDefault(locale);
        long t00 = System.nanoTime();
        if (log.isDebugEnabled()) {
            log.debug((Object)("i18n language : " + locale));
            log.debug((Object)("i18n loading time : " + StringUtil.convertTime((long)t00, (long)System.nanoTime())));
        }
    }

    public MainView getMainUI() {
        return (MainView)MAIN_UI_ENTRY_DEF.getContextValue((JAXXContext)this);
    }

    public void close() throws Exception {
        MainView mainUI;
        if (log.isDebugEnabled()) {
            log.debug((Object)("closing context " + (Object)((Object)this)));
        }
        if ((mainUI = this.getMainUI()) != null && mainUI.isVisible()) {
            mainUI.setVisible(false);
            mainUI.dispose();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("context closed " + (Object)((Object)this)));
        }
    }

    public static LimaSwingApplicationContext getContext() {
        return LimaSwingApplicationContext.get();
    }

    static {
        MAIN_UI_ENTRY_DEF = JAXXUtil.newContextEntryDef((String)"mainUI", MainView.class);
        DECORATOR_PROVIDER_DEF = JAXXUtil.newContextEntryDef((String)"decoratorProvider", DecoratorProvider.class);
        CONFIG_DEF = JAXXUtil.newContextEntryDef((String)"limaConfig", LimaSwingConfig.class);
    }
}

