/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.lima;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.LimaSwingConfig;
import org.chorem.lima.util.ErrorHelper;

public class LimaExceptionHandler
implements Thread.UncaughtExceptionHandler {
    private static final Log log = LogFactory.getLog(LimaExceptionHandler.class);

    @Override
    public void uncaughtException(Thread t, Throwable ex) {
        this.handleException(t.getName(), ex);
    }

    public void handle(Throwable thrown) {
        this.handleException(Thread.currentThread().getName(), thrown);
    }

    protected void handleException(String tname, Throwable ex) {
        if (log.isErrorEnabled()) {
            log.error((Object)"Global application exception", ex);
        }
        ErrorHelper errorHelper = new ErrorHelper(LimaSwingConfig.getInstance());
        errorHelper.showErrorDialog(null, ex.getMessage(), ex);
    }
}

