package org.chorem.lima.ui.home;

/*
 * #%L
 * Lima :: Swing
 * %%
 * Copyright (C) 2008 - 2015 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EtchedBorder;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.Table;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static org.nuiton.i18n.I18n.t;

public class HomeView extends Table implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVWzW8bRRQfu7FDPp2kJEpFi0yoaCrMOklTFEgEzZfphyFVUkFaH2C8O7anrHeG2THZEBXxJ/AnwBHEBYkbJ8SBcw9cEP8CQhy4or4Z2+vd9S5ZqZY8Ws+893u/33ue9/aHv1DOFeiVx9jzDNFxJG0T4+728fFB/TEx5R5xTUG5ZAJ1P5ksytbQhOXvuxK9Wqsq93LPvbzL2pw5xAl4b1bRuCtPbeK2CJESXQl7mK5bPvKPNz3eEX1Un1Qc6jf//J392vrq2yxCHgd28yCleJ7XQMlIFWWpJdEcRPocl23sNIGGoE4T+E6pvV0bu+4HuE0+Q1+i0SrKcywATKKl9JI1hvb3uESjVx/guk1WJCoy0TTMFhOkbdi0jY0ONVoMON+G5UNKTjjXbnmJJrFpMgh1HzvEBr6Kmme4J8DUuKs3leGYRGPUaTC90XftxVuVaDGUmK6zPlOWk0Ox3Dsmc6KxqrjejTUj0QgFg77XVN/Lt5jvmeUklVDYKLoiKdHVpBxsB8w0kM9vGrIsTncY+9QXPn2e+jX1c04tV2JwtFKfcjGirDCwC2srRrUFELvqXktStx8y1GA+r5kGdU1sPyRYuOkV3vAVvu4jFQJIIYlGRGIwZFijEdVYiLCT6FqSyErYUsP53C41qIMdk2L7gcCOi01JmZNe7rov9y0fckKln5Kw1K2I1MmeUVjmVlRmLL2e4NVkwQk+OgSH3vRS6ApC1zMGXW/QljI1lBMd2IY7WxtulIdw1G2Ri5EWqQD16X8LF3//+c+fKv2+WIDY87GmgbYO/YoLxomQVIUudJtiR1K7/D7mmzU05hIbZoLu+ZdjiB31joEcxJtV7oZyN25jtwUQudE/fvl14ZOnF1C2gsZthq0KVvZ3oNQtAVlgtuXxd29pRpMnL8A6A98LUNo2dWi70z6iX0CiFs8cclLcg7COCylevrGyUlq9uXL9CbQhLkiDCEGseNObYLq2pk3zdSYsEIs2znb0U5fMqWEKgiXZl2aLWN2T5eAPo3rw0f7h/t71Jx6U4HJMCfw81Md++/fi0Y+3+mXIQFouJZoPSpF7hPLUsalD9IDqzZ7YgTTBXdKx2GDGxE0dxDkfukxVvd4fSnc2mu6FSA7XN0rrG3HJTjD0OirQsdavnh516Qyu5f8wGWkwNW2vaeQKPC8vuXC33nCJoI2lkt4ydg6qe6Xi6puK03gD7mVTwOyAuT57tstsJoy97cN7H793uP0wiUvg8ieRyfQYB0aYwZ3mMGBkgvLeFD8fNzA+kpAjMys9drBtJ4FHx0V69H7nTUIOduY0qJJ4UPQ53Vx1Z+0nNA48/OaRHv7FAfwgq7F5ibwApA8xPwgRyG1cjKEJnD7IbFgHpDn2PxmceynA8zY+ZR2An96ysMTFOnUseAN8Zwg7o9apcxHV9ndq+T4e4eXnRig9N8LbgPAM7fcDiBANAAA=";
    private static final Log log = LogFactory.getLog(HomeView.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JPanel accountPanel;
    protected JLabel accountsIcon;
    protected JLabel accountsLabel;
    protected AccountsPane accountsPane;
    protected JLabel entriesIcon;
    protected JLabel entriesLabel;
    protected JPanel entryBookPanel;
    protected JLabel entryBooksIcon;
    protected JLabel entryBooksLabel;
    protected EntryBooksPane entryBooksPane;
    protected JPanel financialTransactionPanel;
    protected FinancialTransactionsPane financialTransactionsPane;
    protected JLabel fiscalYearsIcon;
    protected JLabel fiscalYearsLabel;
    protected FiscalYearsPane fiscalYearsPane;
    protected JPanel fiscalYearsPanel;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private HomeView $Table0 = this;
    private Table $Table1;
    private Table $Table2;
    private Table $Table3;
    private Table $Table4;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    public void refresh() {
            accountsPane.refresh();
            entryBooksPane.refresh();
            fiscalYearsPane.refresh();
            financialTransactionsPane.refresh();
        }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public HomeView() {
        $initialize();
    }

    public HomeView(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JPanel getAccountPanel() {
        return accountPanel;
    }

    public JLabel getAccountsIcon() {
        return accountsIcon;
    }

    public JLabel getAccountsLabel() {
        return accountsLabel;
    }

    public AccountsPane getAccountsPane() {
        return accountsPane;
    }

    public JLabel getEntriesIcon() {
        return entriesIcon;
    }

    public JLabel getEntriesLabel() {
        return entriesLabel;
    }

    public JPanel getEntryBookPanel() {
        return entryBookPanel;
    }

    public JLabel getEntryBooksIcon() {
        return entryBooksIcon;
    }

    public JLabel getEntryBooksLabel() {
        return entryBooksLabel;
    }

    public EntryBooksPane getEntryBooksPane() {
        return entryBooksPane;
    }

    public JPanel getFinancialTransactionPanel() {
        return financialTransactionPanel;
    }

    public FinancialTransactionsPane getFinancialTransactionsPane() {
        return financialTransactionsPane;
    }

    public JLabel getFiscalYearsIcon() {
        return fiscalYearsIcon;
    }

    public JLabel getFiscalYearsLabel() {
        return fiscalYearsLabel;
    }

    public FiscalYearsPane getFiscalYearsPane() {
        return fiscalYearsPane;
    }

    public JPanel getFiscalYearsPanel() {
        return fiscalYearsPanel;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected Table get$Table1() {
        return $Table1;
    }

    protected Table get$Table2() {
        return $Table2;
    }

    protected Table get$Table3() {
        return $Table3;
    }

    protected Table get$Table4() {
        return $Table4;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToAccountPanel() {
        if (!allComponentsCreated) {
            return;
        }
        accountPanel.add($Table1);
    }

    protected void addChildrenToEntryBookPanel() {
        if (!allComponentsCreated) {
            return;
        }
        entryBookPanel.add($Table2);
    }

    protected void addChildrenToFinancialTransactionPanel() {
        if (!allComponentsCreated) {
            return;
        }
        financialTransactionPanel.add($Table4);
    }

    protected void addChildrenToFiscalYearsPanel() {
        if (!allComponentsCreated) {
            return;
        }
        fiscalYearsPanel.add($Table3);
    }

    protected void createAccountPanel() {
        $objectMap.put("accountPanel", accountPanel = new JPanel());
        
        accountPanel.setName("accountPanel");
        accountPanel.setLayout(new BoxLayout(accountPanel, BoxLayout.X_AXIS));
    }

    protected void createAccountsIcon() {
        $objectMap.put("accountsIcon", accountsIcon = new JLabel());
        
        accountsIcon.setName("accountsIcon");
    }

    protected void createAccountsLabel() {
        $objectMap.put("accountsLabel", accountsLabel = new JLabel());
        
        accountsLabel.setName("accountsLabel");
        accountsLabel.setText(t("lima.home.accounts"));
    }

    protected void createAccountsPane() {
        $objectMap.put("accountsPane", accountsPane = new AccountsPane(this));
        
        accountsPane.setName("accountsPane");
    }

    protected void createEntriesIcon() {
        $objectMap.put("entriesIcon", entriesIcon = new JLabel());
        
        entriesIcon.setName("entriesIcon");
    }

    protected void createEntriesLabel() {
        $objectMap.put("entriesLabel", entriesLabel = new JLabel());
        
        entriesLabel.setName("entriesLabel");
        entriesLabel.setText(t("lima.home.entries"));
    }

    protected void createEntryBookPanel() {
        $objectMap.put("entryBookPanel", entryBookPanel = new JPanel());
        
        entryBookPanel.setName("entryBookPanel");
        entryBookPanel.setLayout(new BoxLayout(entryBookPanel, BoxLayout.X_AXIS));
    }

    protected void createEntryBooksIcon() {
        $objectMap.put("entryBooksIcon", entryBooksIcon = new JLabel());
        
        entryBooksIcon.setName("entryBooksIcon");
    }

    protected void createEntryBooksLabel() {
        $objectMap.put("entryBooksLabel", entryBooksLabel = new JLabel());
        
        entryBooksLabel.setName("entryBooksLabel");
        entryBooksLabel.setText(t("lima.home.entryBooks"));
    }

    protected void createEntryBooksPane() {
        $objectMap.put("entryBooksPane", entryBooksPane = new EntryBooksPane(this));
        
        entryBooksPane.setName("entryBooksPane");
    }

    protected void createFinancialTransactionPanel() {
        $objectMap.put("financialTransactionPanel", financialTransactionPanel = new JPanel());
        
        financialTransactionPanel.setName("financialTransactionPanel");
        financialTransactionPanel.setLayout(new BoxLayout(financialTransactionPanel, BoxLayout.X_AXIS));
    }

    protected void createFinancialTransactionsPane() {
        $objectMap.put("financialTransactionsPane", financialTransactionsPane = new FinancialTransactionsPane(this));
        
        financialTransactionsPane.setName("financialTransactionsPane");
    }

    protected void createFiscalYearsIcon() {
        $objectMap.put("fiscalYearsIcon", fiscalYearsIcon = new JLabel());
        
        fiscalYearsIcon.setName("fiscalYearsIcon");
    }

    protected void createFiscalYearsLabel() {
        $objectMap.put("fiscalYearsLabel", fiscalYearsLabel = new JLabel());
        
        fiscalYearsLabel.setName("fiscalYearsLabel");
        fiscalYearsLabel.setText(t("lima.home.fiscalYears"));
    }

    protected void createFiscalYearsPane() {
        $objectMap.put("fiscalYearsPane", fiscalYearsPane = new FiscalYearsPane(this));
        
        fiscalYearsPane.setName("fiscalYearsPane");
    }

    protected void createFiscalYearsPanel() {
        $objectMap.put("fiscalYearsPanel", fiscalYearsPanel = new JPanel());
        
        fiscalYearsPanel.setName("fiscalYearsPanel");
        fiscalYearsPanel.setLayout(new BoxLayout(fiscalYearsPanel, BoxLayout.X_AXIS));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // inline complete setup of $Table0
        add(accountPanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 14, 0, new Insets(3, 3, 3, 3), 0, 0));
        add(entryBookPanel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 14, 0, new Insets(3, 3, 3, 3), 0, 0));
        add(fiscalYearsPanel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 12, 0, new Insets(3, 3, 3, 3), 0, 0));
        add(financialTransactionPanel, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(3, 3, 3, 3), 0, 0));
        addChildrenToAccountPanel();
        // inline complete setup of $Table1
        $Table1.add(accountsIcon, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.1, 18, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(accountsLabel, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.1, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(accountsPane, new GridBagConstraints(0, 1, 2, 1, 1.0, 0.9, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        addChildrenToEntryBookPanel();
        // inline complete setup of $Table2
        $Table2.add(entryBooksIcon, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.1, 18, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add(entryBooksLabel, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.1, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add(entryBooksPane, new GridBagConstraints(0, 1, 2, 1, 1.0, 0.9, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        addChildrenToFiscalYearsPanel();
        // inline complete setup of $Table3
        $Table3.add(fiscalYearsIcon, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.1, 18, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table3.add(fiscalYearsLabel, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.1, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table3.add(fiscalYearsPane, new GridBagConstraints(0, 1, 2, 1, 1.0, 0.9, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        addChildrenToFinancialTransactionPanel();
        // inline complete setup of $Table4
        $Table4.add(entriesIcon, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.1, 18, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table4.add(entriesLabel, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.1, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table4.add(financialTransactionsPane, new GridBagConstraints(0, 1, 2, 1, 1.0, 0.9, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        
        // apply 36 property setters
        accountPanel.setMinimumSize(new Dimension(300,150));
        accountPanel.setPreferredSize(new Dimension(500,220));
        accountPanel.setBorder(BorderFactory.createEtchedBorder(EtchedBorder.LOWERED));
        accountsIcon.setIcon(SwingUtil.createImageIcon("accounts.png"));
        accountsIcon.setMinimumSize(new Dimension(48,48));
        accountsIcon.setPreferredSize(new Dimension(48,48));
        accountsLabel.setFont(new Font("sans-serif", Font.BOLD, 16));
        accountsLabel.setForeground(Color.DARK_GRAY);
        entryBookPanel.setMinimumSize(new Dimension(300,150));
        entryBookPanel.setPreferredSize(new Dimension(500,220));
        entryBookPanel.setBorder(BorderFactory.createEtchedBorder(EtchedBorder.LOWERED));
        entryBooksIcon.setIcon(SwingUtil.createImageIcon("entryBooks.png"));
        entryBooksIcon.setMinimumSize(new Dimension(48,48));
        entryBooksIcon.setPreferredSize(new Dimension(48,48));
        entryBooksLabel.setFont(new Font("sans-serif", Font.BOLD, 16));
        entryBooksLabel.setForeground(Color.DARK_GRAY);
        fiscalYearsPanel.setMinimumSize(new Dimension(300,150));
        fiscalYearsPanel.setPreferredSize(new Dimension(500,220));
        fiscalYearsPanel.setBorder(BorderFactory.createEtchedBorder(EtchedBorder.LOWERED));
        fiscalYearsIcon.setIcon(SwingUtil.createImageIcon("fiscalYears.png"));
        fiscalYearsIcon.setMinimumSize(new Dimension(48,48));
        fiscalYearsIcon.setPreferredSize(new Dimension(48,48));
        fiscalYearsLabel.setFont(new Font("sans-serif", Font.BOLD, 16));
        fiscalYearsLabel.setForeground(Color.DARK_GRAY);
        financialTransactionPanel.setMinimumSize(new Dimension(300,150));
        financialTransactionPanel.setPreferredSize(new Dimension(500,220));
        financialTransactionPanel.setBorder(BorderFactory.createEtchedBorder(EtchedBorder.LOWERED));
        entriesIcon.setIcon(SwingUtil.createImageIcon("entries.png"));
        entriesIcon.setMinimumSize(new Dimension(48,48));
        entriesIcon.setPreferredSize(new Dimension(48,48));
        entriesLabel.setFont(new Font("sans-serif", Font.BOLD, 16));
        entriesLabel.setForeground(Color.DARK_GRAY);
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$Table0", $Table0);
        createAccountPanel();
        // inline creation of $Table1
        $objectMap.put("$Table1", $Table1 = new Table());
        
        $Table1.setName("$Table1");
        createAccountsIcon();
        createAccountsLabel();
        createAccountsPane();
        createEntryBookPanel();
        // inline creation of $Table2
        $objectMap.put("$Table2", $Table2 = new Table());
        
        $Table2.setName("$Table2");
        createEntryBooksIcon();
        createEntryBooksLabel();
        createEntryBooksPane();
        createFiscalYearsPanel();
        // inline creation of $Table3
        $objectMap.put("$Table3", $Table3 = new Table());
        
        $Table3.setName("$Table3");
        createFiscalYearsIcon();
        createFiscalYearsLabel();
        createFiscalYearsPane();
        createFinancialTransactionPanel();
        // inline creation of $Table4
        $objectMap.put("$Table4", $Table4 = new Table());
        
        $Table4.setName("$Table4");
        createEntriesIcon();
        createEntriesLabel();
        createFinancialTransactionsPane();
        // inline creation of $Table0
        setName("$Table0");
        
        $completeSetup();
    }

}