package org.chorem.lima.ui.vatchart;

/*
 * #%L
 * Lima :: Swing
 * %%
 * Copyright (C) 2008 - 2015 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dialog.ModalityType;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.JAXXButtonGroup;
import jaxx.runtime.swing.Table;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.enums.VatStatementsChartEnum;
import static org.nuiton.i18n.I18n.t;

public class VatChartImportForm extends JDialog implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_ADD_STATE = "addState";
    public static final String PROPERTY_RADIO_BUTTONS = "radioButtons";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_DEVELOPED_BUTTON_GROUP = "developed.buttonGroup";
    public static final String BINDING_IMPORT_CSV_BUTTON_GROUP = "importCSV.buttonGroup";
    public static final String BINDING_SHORTENED_BUTTON_GROUP = "shortened.buttonGroup";
    public static final String BINDING_VAT_BASE_BUTTON_GROUP = "vatBase.buttonGroup";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAK1Wz28bRRSeuHHcxC2UpgkpbURIeyiXdZF6QKSC1o5Dg9ymiquoqi+Mdyb2NrM7y8zbdFFVxJ/AnwB3LkjcOCEOnDlwQfwLCHHgingza+/a8bhxpfqwWs/79b1v5nuz3/9FylqR957SNPVUEkEQcu+zu48f73Wfch+2ufZVEINUJPvNlUipQ6osX9dArnVaJrw2CK81ZBjLiEcj0VstsqThS8F1n3MAsj4e4Wtda+fmrTRO1DBrDsqV9dt//i59w77+rkRIGiO689jKxmlRRSfzLVIKGJCLWOmY1gSNeghDBVEP8Z43aw1BtX5AQ/4F+YpUWmQhpgqTAdmcvWWbw8anMZDVYwptoMBD9N7FKAU7UoVAPKl6nt+XioeeCELqJYGHvn6fKvAOKDTMSxEQxzbnApBzirJA1hMAGeFubI71r59hN3ZDM4dPlUziIvYsZcyiAfKW6dczHHh1KQWnUeFWuf6IdgW/CWTNkd3ajOdigSmS0Edbi3a5QIJN7nQIxi4ax4u5/6LGxoFHnNkSI877RXPjIRUkp061LfzOiWyMH3MhY85cxsBy2GgfOIxvMy448IORPbK8A1kZQ9Xoc/+oLtMTkDKaPjB/L42bFnwa+YaK5bE8RWPXc9eSPDJvNwarilwZ4xy14hVaKQ7zXIeUVYLLyGBnUl77aMqEtXZCWCahtf63uvz7T3/+uDNUUxVrrzhdR4YBnvJYIdUKAlP6zUxKCQSidp/GWx3cWqTUzybFVQew9sCM4LBedgpNuHeP6j6mKFf++PmX1c9/O0NKO2RJSMp2qPHfJYvQV8iCFCyNP7ljEZ17dhafFww2IGUIAHeTrFs5jerOy86Ad4hCSpGSqw5KclzdxV//XW7/cGdIyxzCvDzVvaCm/IQsBJEIIm7HzGCCOMdKNdY8YbKYFK7ZQfB4uodHb6jom/Z5y0XGPPAUj/HlSS4GUk0TE/uhbdC8fUROyPi0IvM4TrK9NiqeB5XwvOyVybIjiq92i9mECnne4zAie33j/Re4mcdUmISbz0fFqa06m1ESeu17e/uPmg+a2y9cnRQD5rQ2zuSgVydBd3HgvBre9Wl463fbTSfU4WCbHaiD3XwCviZ2t5sHzdbew2ns5uVmB702TZWvhvjdaYh37z/EA+GGm18Bp8EtjZ3p8iEVmr+sg+z6cNWcdrPMLt2qLZfdI64Kgytm9oQVm1AeuZLhJTRDohXGD2kioCGk5nt4CVAIZATkjduMAt3oBhHD6fHxRIE581yaoUA5lIyaD4jb2STdoIDfZ3g8+EuS/g8WkrvS1AoAAA==";
    private static final Log log = LogFactory.getLog(VatChartImportForm.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected Boolean addState;
    protected JButton cancel;
    protected JCheckBox deleteVatStatementChart;
    protected JRadioButton developed;
    protected JRadioButton importCSV;
    protected JLabel nothingLabel;
    protected JButton ok;
    protected JAXXButtonGroup radioButtons;
    protected JRadioButton shortened;
    protected JRadioButton vatBase;
    protected VatChartImportForm vatStatementImportForm = this;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private Table $Table0;
    private Table $Table1;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/
    
        protected void performCancel() {
            getRadioButtons().setSelectedValue(null);
            dispose();
        }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public VatChartImportForm(Frame param0, String param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public VatChartImportForm(JAXXContext parentContext, Frame param1, String param2, boolean param3) {
        super(param1 ,param2 ,param3);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public VatChartImportForm(Frame param0, String param1, boolean param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public VatChartImportForm(JAXXContext parentContext, Frame param1, String param2, boolean param3, GraphicsConfiguration param4) {
        super(param1 ,param2 ,param3 ,param4);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public VatChartImportForm(Dialog param0) {
        super(param0);
        $initialize();
    }

    public VatChartImportForm(JAXXContext parentContext, Dialog param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public VatChartImportForm(Dialog param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public VatChartImportForm(JAXXContext parentContext, Dialog param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public VatChartImportForm() {
        $initialize();
    }

    public VatChartImportForm(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public VatChartImportForm(Frame param0) {
        super(param0);
        $initialize();
    }

    public VatChartImportForm(JAXXContext parentContext, Frame param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public VatChartImportForm(Frame param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public VatChartImportForm(JAXXContext parentContext, Frame param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public VatChartImportForm(Frame param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public VatChartImportForm(JAXXContext parentContext, Frame param1, String param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public VatChartImportForm(Window param0, ModalityType param1) {
        super(param0 ,param1);
        $initialize();
    }

    public VatChartImportForm(JAXXContext parentContext, Window param1, ModalityType param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public VatChartImportForm(Window param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public VatChartImportForm(JAXXContext parentContext, Window param1, String param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public VatChartImportForm(Window param0, String param1, ModalityType param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public VatChartImportForm(JAXXContext parentContext, Window param1, String param2, ModalityType param3) {
        super(param1 ,param2 ,param3);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public VatChartImportForm(Window param0, String param1, ModalityType param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public VatChartImportForm(JAXXContext parentContext, Window param1, String param2, ModalityType param3, GraphicsConfiguration param4) {
        super(param1 ,param2 ,param3 ,param4);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public VatChartImportForm(Dialog param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public VatChartImportForm(JAXXContext parentContext, Dialog param1, String param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public VatChartImportForm(Dialog param0, String param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public VatChartImportForm(JAXXContext parentContext, Dialog param1, String param2, boolean param3) {
        super(param1 ,param2 ,param3);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public VatChartImportForm(Dialog param0, String param1, boolean param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public VatChartImportForm(JAXXContext parentContext, Dialog param1, String param2, boolean param3, GraphicsConfiguration param4) {
        super(param1 ,param2 ,param3 ,param4);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public VatChartImportForm(Window param0) {
        super(param0);
        $initialize();
    }

    public VatChartImportForm(JAXXContext parentContext, Window param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__cancel(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        performCancel();
    }

    public void doActionPerformed__on__ok(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        dispose();
    }

    public void doWindowClosing__on__vatStatementImportForm(WindowEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        performCancel();
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public Boolean getAddState() {
        return addState;
    }

    public JButton getCancel() {
        return cancel;
    }

    public JCheckBox getDeleteVatStatementChart() {
        return deleteVatStatementChart;
    }

    public JRadioButton getDeveloped() {
        return developed;
    }

    public JRadioButton getImportCSV() {
        return importCSV;
    }

    public JLabel getNothingLabel() {
        return nothingLabel;
    }

    public JButton getOk() {
        return ok;
    }

    public JAXXButtonGroup getRadioButtons() {
        return radioButtons;
    }

    public JRadioButton getShortened() {
        return shortened;
    }

    public JRadioButton getVatBase() {
        return vatBase;
    }

    public Boolean isAddState() {
        return addState !=null && addState;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setAddState(Boolean addState) {
        Boolean oldValue = this.addState;
        this.addState = addState;
        firePropertyChange(PROPERTY_ADD_STATE, oldValue, addState);
    }

    public void setRadioButtons(JAXXButtonGroup radioButtons) {
        JAXXButtonGroup oldValue = this.radioButtons;
        this.radioButtons = radioButtons;
        firePropertyChange(PROPERTY_RADIO_BUTTONS, oldValue, radioButtons);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected Table get$Table0() {
        return $Table0;
    }

    protected Table get$Table1() {
        return $Table1;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToVatStatementImportForm() {
        if (!allComponentsCreated) {
            return;
        }
        add($Table0);
    }

    protected void createAddState() {
        $objectMap.put("addState", addState = true);
    }

    protected void createCancel() {
        $objectMap.put("cancel", cancel = new JButton());
        
        cancel.setName("cancel");
        cancel.setText(t("lima.cancel"));
        cancel.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__cancel"));
    }

    protected void createDeleteVatStatementChart() {
        $objectMap.put("deleteVatStatementChart", deleteVatStatementChart = new JCheckBox());
        
        deleteVatStatementChart.setName("deleteVatStatementChart");
        deleteVatStatementChart.setText(t("lima.vatStatement.delete"));
        deleteVatStatementChart.setSelected(false);
    }

    protected void createDeveloped() {
        $objectMap.put("developed", developed = new JRadioButton());
        
        developed.setName("developed");
        developed.setText(t("lima.vatStatement.developed"));
    }

    protected void createImportCSV() {
        $objectMap.put("importCSV", importCSV = new JRadioButton());
        
        importCSV.setName("importCSV");
        importCSV.setText(t("lima.vatStatement.import"));
    }

    protected void createNothingLabel() {
        $objectMap.put("nothingLabel", nothingLabel = new JLabel());
        
        nothingLabel.setName("nothingLabel");
        nothingLabel.setText(t("lima.vatStatement.nothing"));
    }

    protected void createOk() {
        $objectMap.put("ok", ok = new JButton());
        
        ok.setName("ok");
        ok.setText(t("lima.ok"));
        ok.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__ok"));
    }

    protected void createRadioButtons() {
        $objectMap.put("radioButtons", radioButtons = new JAXXButtonGroup());
    }

    protected void createShortened() {
        $objectMap.put("shortened", shortened = new JRadioButton());
        
        shortened.setName("shortened");
        shortened.setText(t("lima.vatStatement.shortened"));
        shortened.setSelected(true);
    }

    protected void createVatBase() {
        $objectMap.put("vatBase", vatBase = new JRadioButton());
        
        vatBase.setName("vatBase");
        vatBase.setText(t("lima.vatStatement.base"));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToVatStatementImportForm();
        // inline complete setup of $Table0
        $Table0.add(nothingLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(shortened, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(vatBase, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(developed, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(importCSV, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(deleteVatStatementChart, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($Table1, new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $Table1
        $Table1.add(cancel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(ok, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        
        // apply 4 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 5 property setters
        setDefaultCloseOperation(JDialog.DO_NOTHING_ON_CLOSE);
        { shortened.putClientProperty("$value", VatStatementsChartEnum.SHORTENED);  Object $buttonGroup = shortened.getClientProperty("$buttonGroup"); if ($buttonGroup instanceof JAXXButtonGroup) { ((JAXXButtonGroup) $buttonGroup).updateSelectedValue(); } }
        
        { vatBase.putClientProperty("$value", VatStatementsChartEnum.BASE);  Object $buttonGroup = vatBase.getClientProperty("$buttonGroup"); if ($buttonGroup instanceof JAXXButtonGroup) { ((JAXXButtonGroup) $buttonGroup).updateSelectedValue(); } }
        
        { developed.putClientProperty("$value", VatStatementsChartEnum.DEVELOPED);  Object $buttonGroup = developed.getClientProperty("$buttonGroup"); if ($buttonGroup instanceof JAXXButtonGroup) { ((JAXXButtonGroup) $buttonGroup).updateSelectedValue(); } }
        
        { importCSV.putClientProperty("$value", VatStatementsChartEnum.IMPORT);  Object $buttonGroup = importCSV.getClientProperty("$buttonGroup"); if ($buttonGroup instanceof JAXXButtonGroup) { ((JAXXButtonGroup) $buttonGroup).updateSelectedValue(); } }
        // late initializer
        vatStatementImportForm.pack();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("vatStatementImportForm", vatStatementImportForm);
        createRadioButtons();
        createAddState();
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new Table());
        
        $Table0.setName("$Table0");
        createNothingLabel();
        createShortened();
        createVatBase();
        createDeveloped();
        createImportCSV();
        createDeleteVatStatementChart();
        // inline creation of $Table1
        $objectMap.put("$Table1", $Table1 = new Table());
        
        $Table1.setName("$Table1");
        createCancel();
        createOk();
        // inline creation of vatStatementImportForm
        setName("vatStatementImportForm");
        setModal(true);
        vatStatementImportForm.addWindowListener(JAXXUtil.getEventListener(WindowListener.class, "windowClosing", this, "doWindowClosing__on__vatStatementImportForm"));
        
        getRootPane().setDefaultButton(ok);// registers 4 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 4 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_SHORTENED_BUTTON_GROUP, true ,"radioButtons") {
        
            @Override
            public void processDataBinding() {
                { ButtonGroup $buttonGroup = getRadioButtons(); shortened.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add(shortened); }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_VAT_BASE_BUTTON_GROUP, true ,"radioButtons") {
        
            @Override
            public void processDataBinding() {
                { ButtonGroup $buttonGroup = getRadioButtons(); vatBase.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add(vatBase); }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_DEVELOPED_BUTTON_GROUP, true ,"radioButtons") {
        
            @Override
            public void processDataBinding() {
                { ButtonGroup $buttonGroup = getRadioButtons(); developed.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add(developed); }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_IMPORT_CSV_BUTTON_GROUP, true ,"radioButtons") {
        
            @Override
            public void processDataBinding() {
                { ButtonGroup $buttonGroup = getRadioButtons(); importCSV.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add(importCSV); }
            }
        });
    }

}