package org.chorem.lima.ui.Filter.StringCondition;

/*
 * #%L
 * Lima :: Swing
 * %%
 * Copyright (C) 2008 - 2015 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JInternalFrame;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;
import javax.swing.text.Document;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.context.DefaultJAXXContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.beans.AbstractStringCondition;
import org.chorem.lima.ui.common.LabelListCellRenderer;
import static org.nuiton.i18n.I18n.t;

public class StringConditionView extends JInternalFrame implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_HANDLER = "handler";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAJ1UTU8UQRAtFpZvREUIBEhWiXFJzCx6xQ9wyQbIIglrDHEv9u4Uu429M2N3DwwSjD/Bn6B3LybePBkPnj14Mf4FYzx4NVbPzn7BEIgcJmxX1atXr+v1u5+QVBKu7rIgsKTvaF5Da315e3uztItlvYKqLLmnXQn1v64EJIowZDfPlYa5Yt6UZ6LyTNatea6DTlv1Yh4GlT4QqKqIWsNsZ0VZqUyhGV4MPF82UJuk4lDf/P6VeG2/epsACDxiZ0ZJnVXVmqQnDwlua7hMnfZYRjCnQjQkdyrEd8ScZQVT6iGr4XN4CX156PWYJDAN184/cogR1geehisqbJB1HZtr7jo5Sega7rqyYpWrrsSaJXiNWT63clxolFahs+D478cc9z0vbNCroa/KHFug1LD034irdYgW6KjroaRDmrLkPnADDeNGnMBS+1RnrTfOTfpAs2pAY6BzHAUpPNGR/6gR6CwYV+goYrCHWaYwW8Xys7hm0XlUK2G648JplazWKrXuuqsISenTsYbJ4snt26JQfe8mj+2dAQyjfyfGvn388SHXvmzjsaltXqEl8KSRT3PTerS+ab7mIrPBvMUiDCgUZLTQSDMxxApRmMhRv0um3DLl1ipTVYJI9n3/9Hni6dduSORgULjMzjGTv0b6VyWp4Ao78O4vhYyG9/vpe9Fw0zDiSdxBKdEu8Bck1dShg/upFWpMt+A66dsLCzdTtxYW5o8CkmUmRpYmt9LAlz9jhfdLDWm6iOrUqekteZJPoJc7gjsYOjEyWazzhjyFvu22zBRnLzjFX160y7Ph9+oJNbo1JGuujULDSl0F3GG+0I3F3jCx9HKJsEnc4/bZrLvD2mPCR5Wenz/SMFy/VrTXNNZo/w8jX1oV1FF+2uT103NiozSGnQ0751kJRZ4rnUUhtqJg2tyBoX49FNf8dwNO+vKsMenSe4wpNYy18zF2PKVDy8NnYSdolsbMGqab+FwV2l0dDh2RmAufpR1u0spNNZuPgFWm/DhS8e/EOYbvFezA9anzhTs20yxV4tTUqdw70aTLfAcJ8R+yfs4fHwcAAA==";
    private static final Log log = LogFactory.getLog(StringConditionView.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected StringConditionHandler handler;
    protected JComboBox operandComboBox;
    protected JCheckBox sensitiveCaseCheckBox;
    protected StringConditionView stringConditionFrame = this;
    protected JTextField textField;

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public StringConditionView(String param0) {
        super(param0);
        $initialize();
    }

    public StringConditionView(JAXXContext parentContext, String param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public StringConditionView() {
        $initialize();
    }

    public StringConditionView(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public StringConditionView(String param0, boolean param1, boolean param2, boolean param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public StringConditionView(JAXXContext parentContext, String param1, boolean param2, boolean param3, boolean param4) {
        super(param1 ,param2 ,param3 ,param4);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public StringConditionView(String param0, boolean param1, boolean param2, boolean param3, boolean param4) {
        super(param0 ,param1 ,param2 ,param3 ,param4);
        $initialize();
    }

    public StringConditionView(JAXXContext parentContext, String param1, boolean param2, boolean param3, boolean param4, boolean param5) {
        super(param1 ,param2 ,param3 ,param4 ,param5);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public StringConditionView(String param0, boolean param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public StringConditionView(JAXXContext parentContext, String param1, boolean param2, boolean param3) {
        super(param1 ,param2 ,param3);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public StringConditionView(String param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public StringConditionView(JAXXContext parentContext, String param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__sensitiveCaseCheckBox(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.setSensitiveCase(event);
    }

    public void doInternalFrameClosed__on__stringConditionFrame(InternalFrameEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.delete();
    }

    public void doItemStateChanged__on__operandComboBox(ItemEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.operandSelected(event);
    }

    public void doKeyReleased__on__textField(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.setText(event);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public StringConditionHandler getHandler() {
        return handler;
    }

    public JComboBox getOperandComboBox() {
        return operandComboBox;
    }

    public JCheckBox getSensitiveCaseCheckBox() {
        return sensitiveCaseCheckBox;
    }

    public JTextField getTextField() {
        return textField;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setHandler(StringConditionHandler handler) {
        StringConditionHandler oldValue = this.handler;
        this.handler = handler;
        firePropertyChange(PROPERTY_HANDLER, oldValue, handler);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToStringConditionFrame() {
        if (!allComponentsCreated) {
            return;
        }
        add(operandComboBox);
        add(textField);
        add(sensitiveCaseCheckBox);
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = new StringConditionHandler(this));
    }

    protected void createOperandComboBox() {
        $objectMap.put("operandComboBox", operandComboBox = new JComboBox());
        
        operandComboBox.setName("operandComboBox");
        operandComboBox.addItemListener(JAXXUtil.getEventListener(ItemListener.class, "itemStateChanged", this, "doItemStateChanged__on__operandComboBox"));
    }

    protected void createSensitiveCaseCheckBox() {
        $objectMap.put("sensitiveCaseCheckBox", sensitiveCaseCheckBox = new JCheckBox());
        
        sensitiveCaseCheckBox.setName("sensitiveCaseCheckBox");
        sensitiveCaseCheckBox.setText(t("lima.filer.condition.sensitive.case"));
        sensitiveCaseCheckBox.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__sensitiveCaseCheckBox"));
    }

    protected void createTextField() {
        $objectMap.put("textField", textField = new JTextField());
        
        textField.setName("textField");
        textField.setColumns(15);
        textField.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__textField"));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToStringConditionFrame();
        
        // apply 7 property setters
        setPreferredSize(new Dimension(200, 100));
        operandComboBox.setModel(new DefaultComboBoxModel(AbstractStringCondition.Operand.values()));
        operandComboBox.setSelectedItem(handler.getOperand());
        operandComboBox.setRenderer(new LabelListCellRenderer());
        SwingUtil.setText(textField, handler.getText());
        
        sensitiveCaseCheckBox.setSelected(handler.isSensitiveCase());
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("stringConditionFrame", stringConditionFrame);
        createHandler();
        createOperandComboBox();
        createTextField();
        createSensitiveCaseCheckBox();
        // inline creation of stringConditionFrame
        setName("stringConditionFrame");
        setVisible(true);
        setClosable(true);
        setDefaultCloseOperation(2);
        stringConditionFrame.getContentPane().setLayout(new FlowLayout(FlowLayout.CENTER, 0, 0));
        stringConditionFrame.addInternalFrameListener(JAXXUtil.getEventListener(InternalFrameListener.class, "internalFrameClosed", this, "doInternalFrameClosed__on__stringConditionFrame"));
        
        stringConditionFrame.pack();
        $completeSetup();
    }

}