/*
 * #%L
 * $Id: FiscalPeriodListRenderer.java 3585 2012-08-08 14:52:14Z tchemit $
 * $HeadURL: https://svn.chorem.org/lima/tags/lima-0.7.3/lima-swing/src/main/java/org/chorem/lima/ui/common/FiscalPeriodListRenderer.java $
 * %%
 * Copyright (C) 2012 Codelutin, Chatellier Eric
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

package org.chorem.lima.ui.common;

import java.awt.Component;
import java.text.DateFormat;

import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;

import org.chorem.lima.entity.FiscalPeriod;

/**
 * Fiscal period list renderer.
 * 
 * @author chatellier
 * @version $Revision: 3585 $
 * 
 * Last update : $Date: 2012-08-08 16:52:14 +0200 (Wed, 08 Aug 2012) $
 * By : $Author: tchemit $
 */
public class FiscalPeriodListRenderer extends DefaultListCellRenderer {

    /** serialVersionUID. */
    private static final long serialVersionUID = -9089182547408397051L;

    @Override
    public Component getListCellRendererComponent(JList list, Object value,
            int index, boolean isSelected, boolean cellHasFocus) {

        FiscalPeriod fiscalPeriod = (FiscalPeriod)value;
        Object newValue = fiscalPeriod;
        if (fiscalPeriod != null) {
            DateFormat df = DateFormat.getDateInstance();
            newValue = df.format(fiscalPeriod.getBeginDate()) + " - " + df.format(fiscalPeriod.getEndDate());
        }
        return super.getListCellRendererComponent(list, newValue, index, isSelected,
                cellHasFocus);
    }

}
