/*
 * #%L
 * Lima Swing
 * 
 * $Id: ComboBoxEntryBooksEnum.java 3777 2014-04-14 07:29:08Z sbavencoff $
 * $HeadURL: https://svn.chorem.org/lima/tags/lima-0.7.3/lima-swing/src/main/java/org/chorem/lima/enums/ComboBoxEntryBooksEnum.java $
 * %%
 * Copyright (C) 2008 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

package org.chorem.lima.enums;

import static org.nuiton.i18n.I18n.t;


public enum ComboBoxEntryBooksEnum {

    ALL(t("lima.enum.comboboxentrybook.all")),
    SELECT_ONE(t("lima.enum.comboboxentrybook.select_one"));

    private final String description;

    ComboBoxEntryBooksEnum(String description) {
        this.description = description;
    }

    public String getDescription() {
        return description;
    }

    public static String[] descriptions() {
        int nbElts = ComboBoxEntryBooksEnum.values().length;
        String[] descriptions = new String[nbElts];
        ComboBoxEntryBooksEnum[] enums = ComboBoxEntryBooksEnum.values();
        for (int i = 0; i < nbElts; i++) {
            descriptions[i] = enums[i].getDescription();
        }
        return descriptions;
    }

    public static ComboBoxEntryBooksEnum valueOfDescription(String description) {
        ComboBoxEntryBooksEnum value = null;

        for (ComboBoxEntryBooksEnum enums : ComboBoxEntryBooksEnum.values()) {
            if (description.equals(enums.description)) {
                value = enums;
                break;
            }
        }
        return value;
    }
}
