/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.lima.ui.home;

import java.util.List;
import javax.swing.event.HyperlinkEvent;
import jaxx.runtime.JAXXContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.LimaContext;
import org.chorem.lima.business.LimaException;
import org.chorem.lima.business.ServiceListener;
import org.chorem.lima.business.api.EntryBookService;
import org.chorem.lima.business.api.ImportService;
import org.chorem.lima.entity.EntryBook;
import org.chorem.lima.service.LimaServiceFactory;
import org.chorem.lima.ui.MainView;
import org.chorem.lima.ui.home.AbstractHomePane;
import org.chorem.lima.ui.home.HomeView;
import org.nuiton.i18n.I18n;

public class EntryBooksPane
extends AbstractHomePane
implements ServiceListener {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(EntryBooksPane.class);
    protected EntryBookService entryBookService = (EntryBookService)LimaServiceFactory.getService(EntryBookService.class);

    public EntryBooksPane(HomeView view) {
        super(view);
        LimaServiceFactory.addServiceListener(EntryBookService.class, (ServiceListener)this);
        LimaServiceFactory.addServiceListener(ImportService.class, (ServiceListener)this);
        this.refresh();
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent e) {
        if (HyperlinkEvent.EventType.ACTIVATED.equals(e.getEventType()) && e.getDescription().equals("#entrybookschart")) {
            MainView ui = (MainView)LimaContext.MAIN_UI_ENTRY_DEF.getContextValue((JAXXContext)this.view);
            ui.getHandler().showEntryBookView((JAXXContext)ui);
        }
    }

    public void refresh() {
        log.debug((Object)"Rafra\u00eechissement entry books pane");
        String htmlBegin = "<font face='sans-serif' size=3><p style=vertical-align:'bottom', horizontal-align:'center'>";
        String htmlEnd = "</p></font>";
        try {
            List entryBooks = this.entryBookService.getAllEntryBooks();
            int ebSize = entryBooks.size();
            if (ebSize > 0) {
                String entryBooksString;
                this.setBackground(GREEN_BACKGROUND);
                if (ebSize == 1) {
                    entryBooksString = I18n.t((String)"lima.ui.home.entrybooks.state.single", (Object[])new Object[0]) + "<br/>" + ((EntryBook)entryBooks.get(0)).getLabel() + "<br/><br/><a href='#entrybookschart'>" + I18n.t((String)"lima.ui.home.entrybooks.modify", (Object[])new Object[0]) + "</a>";
                } else {
                    entryBooksString = I18n.t((String)"lima.ui.home.entrybooks.state1_2.plural", (Object[])new Object[0]) + " " + entryBooks.size() + " " + I18n.t((String)"lima.ui.home.entrybooks.state2_2.plural", (Object[])new Object[0]) + "<ul>";
                    for (int i = 0; i < ebSize && i < 3; ++i) {
                        EntryBook entryBook = (EntryBook)entryBooks.get(i);
                        entryBooksString = entryBooksString + "<li>" + entryBook.getCode() + " - " + entryBook.getLabel() + "</li>";
                    }
                    if (ebSize > 3) {
                        entryBooksString = entryBooksString + "<li> ... </li>";
                    }
                    entryBooksString = entryBooksString + "</ul></p><p horizontal-align:'center'><a href='#entrybookschart'>" + I18n.t((String)"lima.ui.home.entrybooks.modify", (Object[])new Object[0]) + "</a>";
                }
                this.setText(htmlBegin + entryBooksString + htmlEnd);
            } else {
                this.setBackground(RED_BACKGROUND);
                this.setText(htmlBegin + I18n.t((String)"lima.ui.home.entrybooks.nothing", (Object[])new Object[0]) + "<br/><br/><a href='#entrybookschart'>" + I18n.t((String)"lima.ui.home.entrybooks.create", (Object[])new Object[0]) + "</a>" + htmlEnd);
            }
        }
        catch (LimaException eee) {
            log.debug((Object)"Can't get datas account editor pane home", (Throwable)eee);
        }
    }

    public void notifyMethod(String serviceName, String methodeName) {
        log.debug((Object)("Nom de la m\u00e9thode : " + methodeName));
        if (methodeName.contains("EntryBook") || methodeName.contains("importAll") || methodeName.contains("importAs") || methodeName.contains("importEntries")) {
            this.refresh();
        }
    }
}

