/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.lima.ui.financialperiod;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.business.ServiceListener;
import org.chorem.lima.business.api.FinancialPeriodService;
import org.chorem.lima.business.api.FiscalPeriodService;
import org.chorem.lima.business.api.ImportService;
import org.chorem.lima.business.utils.FinancialPeriodComparator;
import org.chorem.lima.entity.ClosedPeriodicEntryBook;
import org.chorem.lima.service.LimaServiceFactory;
import org.chorem.lima.ui.financialperiod.FinancialPeriodTable;
import org.chorem.lima.ui.financialperiod.FinancialPeriodTableModel;
import org.chorem.lima.ui.financialperiod.FinancialPeriodView;
import org.nuiton.i18n.I18n;

public class FinancialPeriodViewHandler
implements ServiceListener {
    private static final Log log = LogFactory.getLog(FinancialPeriodViewHandler.class);
    protected FinancialPeriodService financialPeriodService;
    protected FinancialPeriodView view;

    protected FinancialPeriodViewHandler(FinancialPeriodView view) {
        this.view = view;
        this.financialPeriodService = (FinancialPeriodService)LimaServiceFactory.getService(FinancialPeriodService.class);
        LimaServiceFactory.addServiceListener(ImportService.class, (ServiceListener)this);
        LimaServiceFactory.addServiceListener(FiscalPeriodService.class, (ServiceListener)this);
    }

    public void init() {
        InputMap inputMap = this.view.getInputMap(1);
        ActionMap actionMap = this.view.getActionMap();
        String binding = "close-FinancialPeriod";
        inputMap.put(KeyStroke.getKeyStroke(66, 128), binding);
        actionMap.put(binding, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FinancialPeriodViewHandler.this.blockFinancialPeriod();
            }
        });
        List closedPeriodicEntryBooks = this.financialPeriodService.getAllClosedPeriodicEntryBooksFromUnblockedFiscalPeriod();
        Collections.sort(closedPeriodicEntryBooks, new FinancialPeriodComparator());
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Loaded %d closed periodic entry book", closedPeriodicEntryBooks.size()));
        }
        this.view.getFinancialPeriodTableModel().setValues(closedPeriodicEntryBooks);
    }

    public void blockFinancialPeriod() {
        FinancialPeriodTable financialPeriodeTable = this.view.getFinancialPeriodTable();
        int selectedRow = financialPeriodeTable.getSelectedRow();
        FinancialPeriodTableModel model = (FinancialPeriodTableModel)this.view.getFinancialPeriodTable().getModel();
        ClosedPeriodicEntryBook closedPeriodicEntryBook = (ClosedPeriodicEntryBook)model.get(selectedRow);
        int response = JOptionPane.showConfirmDialog((Component)((Object)this.view), I18n.t((String)"lima.ui.financialperiod.blockmessage", (Object[])new Object[0]), I18n.t((String)"lima.ui.financialperiod.blocktitle", (Object[])new Object[0]), 0, 3);
        if (response == 0) {
            closedPeriodicEntryBook = this.financialPeriodService.blockClosedPeriodicEntryBook(closedPeriodicEntryBook);
            model.setValue(selectedRow, closedPeriodicEntryBook);
        }
    }

    public void notifyMethod(String serviceName, String methodName) {
        if (serviceName.contains("FiscalPeriod") || methodName.contains("importAll")) {
            this.init();
        }
    }
}

