/*
 * #%L
 * Lima Swing
 * *
 * $Id: LetteringTableModel.java 3727 2014-01-02 09:41:08Z sbavencoff $
 * $HeadURL: https://svn.chorem.org/lima/tags/lima-0.7.1/lima-swing/src/main/java/org/chorem/lima/ui/lettering/LetteringTableModel.java $
 * %%
 * Copyright (C) 2008 - 2012 CodeLutin, Chatellier Eric
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

package org.chorem.lima.ui.lettering;

import org.chorem.lima.entity.Account;
import org.chorem.lima.entity.Entry;
import org.chorem.lima.ui.common.AbstractColumn;
import org.chorem.lima.ui.common.AbstractLimaTableModel;

import java.math.BigDecimal;
import java.util.Date;

import static org.nuiton.i18n.I18n._;

/**
 * Basic transaction table model.
 * <p/>
 *
 * @author ore
 * @author chatellier
 */
public class LetteringTableModel extends AbstractLimaTableModel<Entry> {

    /** serialVersionUID. */
    private static final long serialVersionUID = 1L;

    @Override
    protected void initColumn() {
        addColumn(new AbstractColumn<LetteringTableModel>(Date.class, _("lima.table.date"), false) {
            @Override
            public Object getValueAt(int row) {
                Entry entry = tableModel.get(row);
                return entry.getFinancialTransaction().getTransactionDate();
            }
        });

        addColumn(new AbstractColumn<LetteringTableModel>(Account.class, _("lima.table.account"), false) {
            @Override
            public Object getValueAt(int row) {
                Entry entry = tableModel.get(row);
                return entry.getAccount();
            }
        });

        addColumn(new AbstractColumn<LetteringTableModel>(String.class, _("lima.table.voucher"), false) {
            @Override
            public Object getValueAt(int row) {
                Entry entry = tableModel.get(row);
                return entry.getVoucher();
            }
        });

        addColumn(new AbstractColumn<LetteringTableModel>(String.class, _("lima.table.description"), false) {
            @Override
            public Object getValueAt(int row) {
                Entry entry = tableModel.get(row);
                return entry.getDescription();
            }
        });

        addColumn(new AbstractColumn<LetteringTableModel>(String.class, _("lima.table.letter"), false) {
            @Override
            public Object getValueAt(int row) {
                Entry entry = tableModel.get(row);
                return entry.getLettering();
            }
        });

        addColumn(new AbstractColumn<LetteringTableModel>(BigDecimal.class, _("lima.table.debit"), false) {
            @Override
            public Object getValueAt(int row) {
                Entry entry = tableModel.get(row);
                return entry.getDebit() ? entry.getAmount() : BigDecimal.ZERO;
            }
        });

        addColumn(new AbstractColumn<LetteringTableModel>(BigDecimal.class, _("lima.table.credit"), false) {
            @Override
            public Object getValueAt(int row) {
                Entry entry = tableModel.get(row);
                return entry.getDebit() ? BigDecimal.ZERO : entry.getAmount();
            }
        });

    }

}
