package org.chorem.lima.ui.financialtransaction;

/*
 * #%L
 * Lima :: Swing
 * $Id: VoucherColumn.java 3727 2014-01-02 09:41:08Z sbavencoff $
 * $HeadURL: https://svn.chorem.org/lima/tags/lima-0.7.1/lima-swing/src/main/java/org/chorem/lima/ui/financialtransaction/VoucherColumn.java $
 * %%
 * Copyright (C) 2008 - 2013 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import org.chorem.lima.entity.Entry;
import org.chorem.lima.ui.common.AbstractColumn;
import org.chorem.lima.ui.common.FinancialTransactionTableModel;

import static org.nuiton.i18n.I18n._;

/**
 * @author Sylvain Bavencoff <bavencoff@codelutin.com>
 */
public class VoucherColumn extends AbstractColumn<FinancialTransactionTableModel> {

    public VoucherColumn() {
        super(String.class, _("lima.ui.financialtransaction.voucher"), true);
    }

    @Override
    public Object getValueAt(int row) {
        Entry entry = tableModel.get(row);
        return entry.getVoucher();
    }

    @Override
    public boolean setValueAt(Object value, int row) {
        Entry entry = tableModel.get(row);
        String voucher = ((String) value).trim();

        boolean update = (entry.getVoucher() == null || entry.getVoucher().compareTo(voucher) != 0);
        if (update) {
            entry.setVoucher(voucher);
            tableModel.updateEntry(entry);
        }
        return update;
    }
}
