/*
 * #%L
 * Lima Swing
 * 
 * $Id: BalanceTableModel.java 3439 2012-06-04 16:07:10Z echatellier $
 * $HeadURL: https://svn.chorem.org/lima/tags/lima-0.7.1/lima-swing/src/main/java/org/chorem/lima/ui/balance/BalanceTableModel.java $
 * %%
 * Copyright (C) 2008 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

package org.chorem.lima.ui.balance;

import static org.nuiton.i18n.I18n._;

import java.math.BigDecimal;
import java.util.List;

import javax.swing.table.AbstractTableModel;

import org.chorem.lima.beans.BalanceTrial;
import org.chorem.lima.beans.ReportsDatas;
import org.chorem.lima.entity.Account;

/**
 * Entry book table model.
 * By : $Author: echatellier $
 */
public class BalanceTableModel extends AbstractTableModel {

    /** serialVersionUID. */
    private static final long serialVersionUID = 1L;

    /** data cache */
    protected BalanceTrial balanceTrial;

    @Override
    public int getRowCount() {
        int result = 0;
        if (balanceTrial != null) {
            result = balanceTrial.getReportsDatas().size();
        }
        return result;
    }

    @Override
    public int getColumnCount() {
        return 6;
    }

    @Override
    public Class<?> getColumnClass(int column) {

        Class<?> result = null;

        switch (column) {
            case 0:
                result = Account.class;
                break;
            case 1:
                result = String.class;
                break;
            case 2:
                result = BigDecimal.class;
                break;
            case 3:
                result = BigDecimal.class;
                break;
            case 4:
                result = BigDecimal.class;
                break;
            case 5:
                result = BigDecimal.class;
                break;
        }

        return result;
    }

    @Override
    public String getColumnName(int column) {
        String res = "n/a";
        switch (column) {
            case 0:
                res = _("lima.table.number"); // Numero de compte
                break;
            case 1:
                res = _("lima.table.label"); // Label
                break;
            case 2:
                res = _("lima.table.move.debit"); // Total Debit
                break;
            case 3:
                res = _("lima.table.move.credit"); // Total Credit
                break;
            case 4:
                res = _("lima.table.solde.debit"); //Solde Debit
                break;
            case 5:
                res = _("lima.table.solde.credit"); //Solde Credit
                break;
        }
        return res;
    }

    @Override
    public Object getValueAt(int row, int column) {
        Object result = null;
        ReportsDatas currentRow = ((List<ReportsDatas>) balanceTrial.getReportsDatas()).get(row);
        //get entries for the period for the current row 
        switch (column) {
            case 0:
                result = currentRow.getAccount().getAccountNumber(); //account number
                break;
            case 1:
                result = currentRow.getAccount().getLabel(); //account label
                break;
            case 2:
                result = currentRow.getAmountDebit(); // total debit
                break;
            case 3:
                result = currentRow.getAmountCredit(); // total crédit
                break;
            case 4: // solde debit
                if (currentRow.getSoldeDebit()) {
                    result = currentRow.getAmountSolde();
                } else {
                    result = BigDecimal.ZERO;
                }
                break;
            case 5: // solde credit
                if (!currentRow.getSoldeDebit()) {
                    result = currentRow.getAmountSolde();
                } else {
                    result = BigDecimal.ZERO;
                }
                break;
        }

        return result;
    }

    public void setBalanceTrial(BalanceTrial balanceTrial) {
        this.balanceTrial = balanceTrial;
        fireTableDataChanged();
    }

}
