/*
 * #%L
 * $Id: AccountTreeTableRenderer.java 3585 2012-08-08 14:52:14Z tchemit $
 * $HeadURL: https://svn.chorem.org/lima/tags/lima-0.7.1/lima-swing/src/main/java/org/chorem/lima/ui/account/AccountTreeTableRenderer.java $
 * %%
 * Copyright (C) 2012 Codelutin, Chatellier Eric
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

package org.chorem.lima.ui.account;

import java.awt.Component;

import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;

import org.chorem.lima.entity.Account;
import org.jdesktop.swingx.treetable.MutableTreeTableNode;

/**
 * Account renderer in account tree.
 * 
 * @author chatellier
 * @version $Revision: 3585 $
 * 
 * Last update : $Date: 2012-08-08 16:52:14 +0200 (Wed, 08 Aug 2012) $
 * By : $Author: tchemit $
 */
public class AccountTreeTableRenderer extends DefaultTreeCellRenderer {

    /** serialVersionUID. */
    private static final long serialVersionUID = -3249368726501873583L;

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value,
            boolean selected, boolean expanded, boolean leaf, int row,
            boolean hasFocus) {

        MutableTreeTableNode node = (MutableTreeTableNode)value;
        Account account = (Account)node.getUserObject();
        Object localValue = value;
        if (account != null) {
            localValue = account.getAccountNumber();
        }
        return super.getTreeCellRendererComponent(tree, localValue, selected, expanded,
            leaf, row, hasFocus);
    }
 
}
