package org.chorem.lima.ui.Filter.financialTransactionCondition;

/*
 * #%L
 * Lima :: Swing
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2008 - 2014 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.ListSelectionModel;
import javax.swing.text.Document;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.JAXXButtonGroup;
import jaxx.runtime.swing.Table;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static org.nuiton.i18n.I18n._;

public class FinancialTransactionConditionView extends Table implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_HANDLER = "handler";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAALVUz08TQRR+rbSlgAgSCEaMKP6IB7cmHiEKYiqSKgaIQevB6e7YDpnOjDOzslyMf4J/gt69mHjzZDx49uDF+C8Y48Gr8c1u26VYkUjsYbqZ977vfe/t9/bVV8gZDac2SRR5OhSWNam3vLCxsVLbpL69To2vmbJSQ/LLZCFbhcGgc28szFQrDl5qwUuLsqmkoGIHerYCA8Zuc2oalFoLJ7oRvjGltU54NlKhbrN2RPViffH9W/Z58OxlFiBSqC6PrUz/DZV20leBLAssHMVKT0iJE1FHGZqJOuo97O4WOTHmNmnSx/AUChXIK6KRzMLp/bccc8T4SFkonFknNU4vWbgndd3zG1LTpsdZk3gh88qMW6q9R0wQ4TPC1zURhviWSbEoRcDcAybtEb3L6JZScb08VmsQEXCqLTz4L9WWEvq04PAC56skYPJaaK0UFibdGCPPbOFUveUdIQcoprgVQXcFR3dl+O2id4igHN9aF3N82Y0Y0ikh2vR0lzFaMHR6knBDy1BhHxqOd+WhNb3Umql3MlXI6RCvscXq725exVDi48ldPnaEcfTnxNint1/elNvmLWDt8Z6pO3YPTaW0VPhGmSt9JHFuaBkv3SJqtgpFQzkubryYUz2ErbXCKA7rjTq45+DeEjENpMgVPr97P/Hw4yHIlmGASxKUicu/CUXb0DgFyYNIXZ2PFQ1t9eM54rRZGKylg8S3M8cEZ4JOE4sbhSF6JcJpTPWYRkdSrfjhx9ja6/n2RDKo8Ngf09Op5O5DPqkWL3RrV3su8KAyNAxkupO9tjTj/kdUy9Un43OmV8v9ybApfkOG5wJiyXSNoUlFHXt1oPNxE+7pwr45+yyNrIue+1cOd312D4axfTFcdId3EIbLB9JgIc/JtgztHjrGkeUXS1Y9M8IGAAA=";
    private static final Log log = LogFactory.getLog(FinancialTransactionConditionView.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JRadioButton AllRadioButton;
    protected JRadioButton OneRadioButton;
    protected JPanel conditionPanel;
    protected FinancialTransactionConditionHandler handler;
    protected JAXXButtonGroup radioButtons;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private FinancialTransactionConditionView $Table0 = this;

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public FinancialTransactionConditionView() {
        $initialize();
    }

    public FinancialTransactionConditionView(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__AllRadioButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.setAllConditions(false);
    }

    public void doActionPerformed__on__OneRadioButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.setAllConditions(true);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JRadioButton getAllRadioButton() {
        return AllRadioButton;
    }

    public JPanel getConditionPanel() {
        return conditionPanel;
    }

    public FinancialTransactionConditionHandler getHandler() {
        return handler;
    }

    public JRadioButton getOneRadioButton() {
        return OneRadioButton;
    }

    public JAXXButtonGroup getRadioButtons() {
        return radioButtons;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setHandler(FinancialTransactionConditionHandler handler) {
        FinancialTransactionConditionHandler oldValue = this.handler;
        this.handler = handler;
        firePropertyChange(PROPERTY_HANDLER, oldValue, handler);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToAllRadioButton() {
        if (!allComponentsCreated) {
            return;
        }
        { ButtonGroup $buttonGroup = radioButtons; AllRadioButton.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add(AllRadioButton); }
    }

    protected void addChildrenToOneRadioButton() {
        if (!allComponentsCreated) {
            return;
        }
        { ButtonGroup $buttonGroup = radioButtons; OneRadioButton.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add(OneRadioButton); }
    }

    protected void createAllRadioButton() {
        $objectMap.put("AllRadioButton", AllRadioButton = new JRadioButton());
        
        AllRadioButton.setName("AllRadioButton");
        AllRadioButton.setText(_("lima.filter.condition.one"));
        AllRadioButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__AllRadioButton"));
    }

    protected void createConditionPanel() {
        $objectMap.put("conditionPanel", conditionPanel = new JPanel());
        
        conditionPanel.setName("conditionPanel");
        conditionPanel.setLayout(new BoxLayout(conditionPanel, BoxLayout.PAGE_AXIS));
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = new FinancialTransactionConditionHandler(this));
    }

    protected void createOneRadioButton() {
        $objectMap.put("OneRadioButton", OneRadioButton = new JRadioButton());
        
        OneRadioButton.setName("OneRadioButton");
        OneRadioButton.setText(_("lima.filter.condition.all"));
        OneRadioButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__OneRadioButton"));
    }

    protected void createRadioButtons() {
        $objectMap.put("radioButtons", radioButtons = new JAXXButtonGroup());
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // inline complete setup of $Table0
        add(AllRadioButton, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 13, 0, new Insets(3, 3, 3, 3), 0, 0));
        add(OneRadioButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        add(conditionPanel, new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        addChildrenToAllRadioButton();
        addChildrenToOneRadioButton();
        
        // apply 3 property setters
        AllRadioButton.setSelected(!handler.isAllConditions());
        OneRadioButton.setSelected(handler.isAllConditions());
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$Table0", $Table0);
        createHandler();
        createAllRadioButton();
        createOneRadioButton();
        createConditionPanel();
        createRadioButtons();
        // inline creation of $Table0
        setName("$Table0");
        
        $completeSetup();
    }

}