/*
 * #%L
 * Lima Swing
 * 
 * $Id: JWideComboBox.java 3278 2011-08-16 14:09:44Z tchemit $
 * $HeadURL: http://svn.chorem.org/svn/lima/tags/lima-0.5.1/lima-swing/src/main/java/org/chorem/lima/widgets/JWideComboBox.java $
 * %%
 * Copyright (C) 2008 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

package org.chorem.lima.widgets;

import java.awt.Dimension;

import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JScrollPane;
import javax.swing.plaf.basic.BasicComboPopup;
import javax.swing.plaf.basic.ComboPopup;
import javax.swing.plaf.metal.MetalComboBoxUI;

// put it at begin, otherwise jaxx complains again !!!
class ScrollMetalComboUI extends MetalComboBoxUI {

    @Override
    protected ComboPopup createPopup() {
        return new ScrollBasicComboPopup(comboBox);
    }
}

//put it at begin, otherwise jaxx complains again !!!
class ScrollBasicComboPopup extends BasicComboPopup {

    /** serialVersionUID. */
    private static final long serialVersionUID = 2353523521723292218L;

    public ScrollBasicComboPopup(JComboBox combo) {
        super(combo);
    }

    @Override
    protected JScrollPane createScroller() {
        return new JScrollPane(list, JScrollPane.VERTICAL_SCROLLBAR_AS_NEEDED,
                JScrollPane.HORIZONTAL_SCROLLBAR_AS_NEEDED);
    }
}

/**
 * Cette combo box surcharge quelques methodes de l'UI par defaut
 * pour que le composant popup soit plus grand que la combobox
 * elle même.
 * 
 * @author ore
 */
public class JWideComboBox extends JComboBox {

    /** serialVersionUID. */
    private static final long serialVersionUID = -6715271536163434385L;

    private boolean layingOut = false;

    public JWideComboBox() {
        super();
        setUI(new ScrollMetalComboUI());
    }

    public JWideComboBox(final Object items[]) {
        super(items);
    }

    public JWideComboBox(ComboBoxModel aModel) {
        super(aModel);
    }

    @Override
    public void doLayout() {
        try {
            layingOut = true;
            super.doLayout();
        } finally {
            layingOut = false;
        }
    }

    @Override
    public Dimension getSize() {
        Dimension dim = super.getSize();
        if (!layingOut) {
            int max = Math.max(dim.width, getPreferredSize().width);
            dim.width = max > 600 ? 600 : max;
        }
        return dim;
    }
}
