/*
 * #%L
 * Lima Swing
 * 
 * $Id: FinancialPeriodViewHandler.java 3278 2011-08-16 14:09:44Z tchemit $
 * $HeadURL: http://svn.chorem.org/svn/lima/tags/lima-0.5.1/lima-swing/src/main/java/org/chorem/lima/ui/financialperiod/FinancialPeriodViewHandler.java $
 * %%
 * Copyright (C) 2008 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

package org.chorem.lima.ui.financialperiod;

import static org.nuiton.i18n.I18n._;

import javax.swing.JOptionPane;

import org.jdesktop.swingx.JXTable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.business.LimaException;
import org.chorem.lima.entity.ClosedPeriodicEntryBook;
import org.chorem.lima.util.DialogHelper;

/**
 * TODO add comment here.
 * 
 * @author chatellier
 * @version $Revision: 3278 $
 * 
 * Last update : $Date: 2011-08-16 16:09:44 +0200 (Tue, 16 Aug 2011) $
 * By : $Author: tchemit $
 */
public class FinancialPeriodViewHandler {

    private static final Log log = LogFactory.getLog(FinancialPeriodViewHandler.class);
    
    protected FinancialPeriodView view;
    
    protected FinancialPeriodTable table;
    
    protected FinancialPeriodTableModel tableModel;
    
    protected FinancialPeriodViewHandler(FinancialPeriodView view) {
        this.view = view;
    }

    public void blockFinancialPeriod() {
        JXTable financialPeriodeTable = view.getFinancialPeriodTable();
        int selectedRow = financialPeriodeTable.getSelectedRow();
        FinancialPeriodTableModel model = (FinancialPeriodTableModel)view.getFinancialPeriodTable().getModel();
        
        // blocked it
        try {
            ClosedPeriodicEntryBook closedPeriodicEntryBook = model.getFinancialPeriodAtRow(selectedRow);
            int response = JOptionPane.showConfirmDialog(view, _("lima.charts.financialperiod.question.blocked"),
                    _("lima.common.question"), JOptionPane.YES_NO_OPTION, JOptionPane.QUESTION_MESSAGE);

            if (response == JOptionPane.YES_OPTION) {
                model.blockFinancialPeriod(closedPeriodicEntryBook);
            }
        } catch (LimaException eee) {
            if (log.isErrorEnabled()) {
                log.error("Can't block financialperiod", eee);
            }
            DialogHelper.showMessageDialog(eee.getMessage());
        }
    }
    
    public FinancialPeriodView getView() {
        return view;
    }
    
    public void refresh() {
        tableModel = (FinancialPeriodTableModel)getView().getFinancialPeriodTable().getModel();
        tableModel.refresh();
    }
}
