/*
 * #%L
 * Lima :: Swing
 * 
 * $Id: EmptyCellRenderer.java 3278 2011-08-16 14:09:44Z tchemit $
 * $HeadURL: http://svn.chorem.org/svn/lima/tags/lima-0.5.1/lima-swing/src/main/java/org/chorem/lima/ui/celleditor/EmptyCellRenderer.java $
 * %%
 * Copyright (C) 2008 - 2011 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package org.chorem.lima.ui.celleditor;

import java.awt.Color;
import java.awt.Component;

import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.table.DefaultTableCellRenderer;

import org.chorem.lima.entity.EntryBook;

import sun.swing.DefaultLookup;

@SuppressWarnings("restriction")
public class EmptyCellRenderer extends DefaultTableCellRenderer {

	private static final long serialVersionUID = -7834417406160620726L;

	public Component getTableCellRendererComponent(JTable table, Object value,
        boolean isSelected, boolean hasFocus, int row, int column)
    {
        //Create a new JLabel to avoid colouring only when row is selected
        JLabel mycell = new JLabel();
        mycell.setOpaque(true);
        setBorder(new EmptyBorder(1, 1, 1, 1));
        setName("Table.cellRenderer");
        mycell.setBackground(Color.WHITE);
        mycell.setForeground(Color.BLACK);
        //Setting default foreGround and backGround colours when isSelected
        if (isSelected) {
            mycell.setForeground(table.getSelectionForeground());
            mycell.setBackground(table.getSelectionBackground());
        }
        //Setting default foreGround and backGround colours when hasFocus
        if (hasFocus) {
         Border border = null;
            if (isSelected) {
                border = DefaultLookup.getBorder(this, ui, "Table.focusSelectedCellHighlightBorder");
            }
            if (border == null) {
                border = DefaultLookup.getBorder(this, ui, "Table.focusCellHighlightBorder");
            }
            mycell.setBorder(border);
        }
        if (table.isCellEditable(row, column)) {
            // true for voucher and description
            // false for Account Class
            // if empty or null, colour background in red
            // else setText
            if (value instanceof String) {
                if (String.valueOf(value).isEmpty() || (String.valueOf(value) == null)) {
                    mycell.setBackground(new Color(255, 198, 209));
                } else {
                     mycell.setText(value.toString());
                }
             } else {
                 mycell.setBackground(new Color(255, 198, 209));
             }
        }
        return mycell;
    }

}
