/*
 * #%L
 * Lima Swing
 * 
 * $Id: DateTableCellEditor.java 3278 2011-08-16 14:09:44Z tchemit $
 * $HeadURL: http://svn.chorem.org/svn/lima/tags/lima-0.5.1/lima-swing/src/main/java/org/chorem/lima/ui/celleditor/DateTableCellEditor.java $
 * %%
 * Copyright (C) 2008 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

package org.chorem.lima.ui.celleditor;

import org.apache.commons.lang.time.DateUtils;
import org.chorem.lima.LimaContext;
import org.jdesktop.swingx.JXDatePicker;

import javax.swing.*;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.table.TableCellEditor;

import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;

import java.util.Date;
import java.util.EventObject;

/**
 * @author ore
 */
public class DateTableCellEditor extends AbstractCellEditor
        implements TableCellEditor, FocusListener, AncestorListener {

    private final JXDatePicker datePicker;
    private static final long serialVersionUID = 1L;
    private static DateTableCellEditor editor;
    
    //used to tell if the user has pressed a key
    private Date date;

    /**
     * constructor
     */
    public DateTableCellEditor() {
        datePicker = new JXDatePicker(LimaContext.getContext().getConfig().getLocale());
        datePicker.getEditor().addFocusListener(this);
        datePicker.getEditor().addAncestorListener(this);
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        if (value instanceof Date) {
            datePicker.setDate((Date) value);
            date = (Date) value;
        }
        return datePicker;
    }

    @Override
    public Object getCellEditorValue() {
        if (!datePicker.getEditor().getText().isEmpty()) {
            String[] str = datePicker.getEditor().getText().split("/");
            //day
            if (str.length > 0) {
                if (str[0].contains(" ")) {
                    String[] string = str[0].split(" ");
                    date = DateUtils.setDays(date, Integer.valueOf(string[1]));
                } else {
                    date = DateUtils.setDays(date, Integer.valueOf(str[0]));
                }
            }
            //month
            if (str.length > 1) {
                date = DateUtils.setMonths(date, Integer.valueOf(str[1])-1);
            }
            //year
            if (str.length > 2) {
                date = DateUtils.setYears(date, Integer.valueOf(str[2]));
            }
        }
        datePicker.setDate(date);
        return datePicker.getDate();
    }

    @Override
    public boolean isCellEditable(EventObject evt) {
        return !(evt instanceof MouseEvent) || ((MouseEvent) evt).getClickCount() == 2;
    }

    public static DateTableCellEditor getInstance() {
        if (editor == null) {
            editor = new DateTableCellEditor();
        }
        return editor;
    }
    
    /**
     * Listeners
     */
    public void focusGained(FocusEvent e) {
        SwingUtilities.invokeLater(new Runnable() {
            public void run() {
                datePicker.getEditor().selectAll();
           }
        });
    }
    
    public void focusLost(FocusEvent e) {
    }

    @Override
    public void ancestorAdded(final AncestorEvent e) {
        SwingUtilities.invokeLater(new Runnable() {
            public void run() {
                datePicker.requestFocus();
           }
        });
    }

    @Override
    public void ancestorRemoved(AncestorEvent e) {
    }

    @Override
    public void ancestorMoved(AncestorEvent e) {
    }

}
