/*
 * #%L
 * Lima :: Swing
 * 
 * $Id: VatStatementsChartEnum.java 3278 2011-08-16 14:09:44Z tchemit $
 * $HeadURL: http://svn.chorem.org/svn/lima/tags/lima-0.5.1/lima-swing/src/main/java/org/chorem/lima/enums/VatStatementsChartEnum.java $
 * %%
 * Copyright (C) 2008 - 2011 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package org.chorem.lima.enums;

public enum VatStatementsChartEnum {

    IMPORT(""), SHORTENED("vat_shortened.csv"), BASE("vat_base.csv"),
    DEVELOPED("vat_developed.csv"), DEFAULT("vat_default.csv");
    
    private final String filePath;
    
    private VatStatementsChartEnum(String filePath) {
        this.filePath = filePath;
        
    }
    
    public String getFilePath() {
        String result = "";
            if (!this.filePath.equals("")){
                result=getClass().getResource("/import/"+this.filePath).getPath();
            }
        return result;
    }
}
