/*
 * #%L
 * Lima Swing
 * 
 * $Id: FinancialTransactionSearchTable.java 3051 2010-11-29 14:57:16Z echatellier $
 * $HeadURL: http://svn.chorem.org/svn/lima/tags/lima-0.4.3/lima-swing/src/main/java/org/chorem/lima/ui/financialtransactionsearch/FinancialTransactionSearchTable.java $
 * %%
 * Copyright (C) 2008 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

package org.chorem.lima.ui.financialtransactionsearch;

import java.awt.Color;
import java.awt.Component;
import java.math.BigDecimal;
import java.util.Date;
import org.chorem.lima.entity.Account;
import org.chorem.lima.entity.EntryBook;
import org.chorem.lima.ui.celleditor.AccountTableCellEditor;
import org.chorem.lima.ui.celleditor.DateTableCellEditor;
import org.chorem.lima.ui.celleditor.EntryBookTableCellEditor;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.decorator.ColorHighlighter;
import org.jdesktop.swingx.decorator.ComponentAdapter;
import org.jdesktop.swingx.decorator.HighlightPredicate;
import org.jdesktop.swingx.decorator.Highlighter;


/**
 * Table des transaction qui ajoute des comportement (keys).
 * 
 * @author ore
 * @author Rémi Chapelet
 */
public class FinancialTransactionSearchTable extends JXTable {

    /** serialVersionUID. */
    private static final long serialVersionUID = 3133690382049594727L;

    protected FinancialTransactionSearchViewHandler handler;

    private Highlighter colorTransaction;

    private ColorHighlighter colorBalance;

    /**
     */
    public FinancialTransactionSearchTable(FinancialTransactionSearchViewHandler handler) {

        this.handler = handler;
        
        //Get new date editor
        setDefaultEditor(Date.class, new DateTableCellEditor());
        //Get new entry book editor
        setDefaultEditor(EntryBook.class, new EntryBookTableCellEditor());
        //Get new account editor
        setDefaultEditor(Account.class, new AccountTableCellEditor());
                
        //highlight financial financial transactions
        addColorTransaction();
        // highlight unbalanced financial transactions
        addColorNonBalancedTransaction();
    }

    /**
     * Cette méthode permet de colorer toutes les transactions dans le tableau
     * afin de bien distinguer les transactions et entrées comptables.
     * On récupère la première cellule, on vérifie que c'est une date
     */
   protected void addColorTransaction() {
       if (colorTransaction != null) {
           removeHighlighter(colorTransaction);
       }
       HighlightPredicate predicate = new HighlightPredicate() {
           @Override
           public boolean isHighlighted(Component renderer,
                   ComponentAdapter adapter) {
               return adapter.getValueAt(adapter.row, 0) instanceof Date;
           }
       };
        colorTransaction =
            new ColorHighlighter(predicate, new Color(222,222,222), null);
        addHighlighter(colorTransaction);
    }

   
   
    /**
     * Permet de surligner une transaction dans le tableau lorsque
     * cette dernière n'est pas équilibrée.
     * On récupère la dernière cellule de la ligne
     * et on vérifie si la valeur est différente de 0
     */
    protected void addColorNonBalancedTransaction() {
        if (colorBalance != null) {
            removeHighlighter(colorBalance);
        }
        HighlightPredicate predicate = new HighlightPredicate() {
            @Override
            public boolean isHighlighted(Component renderer,
                    ComponentAdapter adapter) {
                boolean isHighlighted = false;
                Object value = adapter.getValueAt(adapter.row, 8);
                if (value instanceof BigDecimal) {
                    BigDecimal currentBalance = (BigDecimal) value;
                    if (currentBalance.doubleValue() != 0) {
                        isHighlighted = true;
                    }
                }
                return isHighlighted;
            }
        };
        colorTransaction = 
            new ColorHighlighter(predicate, new Color(255, 198, 209), null);
        addHighlighter(colorTransaction);
    }
}
