/*
 * #%L
 * Lima Swing
 * 
 * $Id: EntryBookViewHandler.java 3051 2010-11-29 14:57:16Z echatellier $
 * $HeadURL: http://svn.chorem.org/svn/lima/tags/lima-0.4.3/lima-swing/src/main/java/org/chorem/lima/ui/entrybook/EntryBookViewHandler.java $
 * %%
 * Copyright (C) 2008 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

package org.chorem.lima.ui.entrybook;

import static org.nuiton.i18n.I18n._;
import javax.swing.JOptionPane;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.business.EntryBookServiceMonitorable;
import org.chorem.lima.business.LimaException;
import org.chorem.lima.business.ejbinterface.EntryBookService;
import org.chorem.lima.entity.EntryBook;
import org.chorem.lima.entity.EntryBookImpl;
import org.chorem.lima.enums.EntryBooksChartEnum;
import org.chorem.lima.enums.ImportExportEnum;
import org.chorem.lima.service.LimaServiceFactory;
import org.chorem.lima.ui.importexport.ImportExport;
import org.chorem.lima.util.DialogHelper;
import org.jdesktop.swingx.JXTable;

/**
 * Handler for entry book view.
 * 
 * @author chatellier
 * @version $Revision: 3051 $
 * 
 * Last update : $Date: 2010-11-29 15:57:16 +0100 (lun., 29 nov. 2010) $
 * By : $Author: echatellier $
 */
public class EntryBookViewHandler {

    private static final Log log = LogFactory.getLog(EntryBookViewHandler.class);
    
    protected EntryBookView view;
    
    protected EntryBookService entryBookService;
        
    public EntryBookViewHandler(EntryBookView view) {
        this.view = view;
        entryBookService =
            LimaServiceFactory.getInstance().getService(
                    EntryBookServiceMonitorable.class);
        }
    
    public void addEntryBook() {

        JXTable entryBookTable = view.getEntryBooksTable();
        EntryBookTableModel entryBookTableModel =
            (EntryBookTableModel)entryBookTable.getModel();

        EntryBook newEntryBook = new EntryBookImpl();
        EntryBookForm entryBookForm = new EntryBookForm(view);
        entryBookForm.setEntryBook(newEntryBook);
        // jaxx constructor don't call super() ?
        entryBookForm.setLocationRelativeTo(view);
        entryBookForm.setVisible(true);
        
        // null == cancel action
        newEntryBook = entryBookForm.getEntryBook();
        if (newEntryBook != null) {

            // add it
            try {
                entryBookTableModel.addEntryBook(newEntryBook);
            } catch (LimaException eee) {
                if (log.isErrorEnabled()) {
                    log.error("Can't add entry book", eee);
                }
                DialogHelper.showMessageDialog(eee.getMessage());
            }
        }
    }

    public void updateEntryBook() {

        JXTable entryBookTable = view.getEntryBooksTable();
        int selectedRow = entryBookTable.getSelectedRow();
        EntryBookTableModel entryBookTableModel =
            (EntryBookTableModel)entryBookTable.getModel();

        // add it
        try {
            EntryBook selectedEntryBook =
                entryBookTableModel.getEntryBookAtRow(selectedRow);
            EntryBookForm entryBookForm = new EntryBookForm(view);
            entryBookForm.setEntryBook(selectedEntryBook);
            // jaxx constructor don't call super() ?
            entryBookForm.setLocationRelativeTo(view);
            entryBookForm.setVisible(true);
            
            // null == cancel action
            selectedEntryBook = entryBookForm.getEntryBook();
            if (selectedEntryBook != null) {
                entryBookTableModel.updateEntryBook(selectedEntryBook);
            }
        } catch (LimaException eee) {
            if (log.isErrorEnabled()) {
                log.error("Can't add update book", eee);
            }
            DialogHelper.showMessageDialog(eee.getMessage());
        }
    }

    public void deleteEntryBook() {
        JXTable entryBookTable = view.getEntryBooksTable();
        int selectedRow = entryBookTable.getSelectedRow();
        EntryBookTableModel entryBookTableModel =
            (EntryBookTableModel)entryBookTable.getModel();

        // add it
        try {
            EntryBook selectedEntryBook =
                entryBookTableModel.getEntryBookAtRow(selectedRow);
            
            int response =
                    JOptionPane.showConfirmDialog(view,
                    _("lima.charts.entrybook.confirmation",
                    selectedEntryBook.getLabel()),
                    _("lima.common.confirmation"), JOptionPane.YES_NO_OPTION,
                    JOptionPane.QUESTION_MESSAGE);

            if (response == JOptionPane.YES_OPTION) {
                entryBookTableModel.removeEntryBook(selectedEntryBook);
            }
        } catch (LimaException eee) {
            if (log.isErrorEnabled()) {
                log.error("Can't delete update book", eee);
            }
            DialogHelper.showMessageDialog(eee.getMessage());
        }
    }
    
    
    public void importEntryBooks(){
                
        EntryBookImportForm form =
            new EntryBookImportForm();
        form.setLocationRelativeTo(view);
        form.setVisible(true);

        Object value = form.getRadioButtons().getSelectedValue();
        // if action confirmed
        if (value != null){
            EntryBooksChartEnum defaultEntryBooksEnum =
                (EntryBooksChartEnum) value;
            ImportExport importExport = ImportExport.getInstance(view);
            importExport.importExport(ImportExportEnum.CSV_ENTRYBOOKS_IMPORT,
                    defaultEntryBooksEnum.getFilePath(), true);
        }
    }
    
}

