/*
 * #%L
 * Lima :: Swing
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2008 - 2011 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package org.chorem.lima.ui.entrybook;

import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.lang.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import jaxx.runtime.*;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.*;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.ui.entrybook.*;
import static jaxx.runtime.SwingUtil.createImageIcon;
import static org.nuiton.i18n.I18n._;

public class EntryBookForm extends javax.swing.JDialog implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_ADD_STATE = "addState";
    public static final String PROPERTY_ENTRY_BOOK = "entryBook";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_ENTRY_BOOK_CODE_FIELD_TEXT = "entryBookCodeField.text";
    public static final String BINDING_ENTRY_BOOK_LABEL_FIELD_EDITABLE = "entryBookLabelField.editable";
    public static final String BINDING_ENTRY_BOOK_LABEL_FIELD_TEXT = "entryBookLabelField.text";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVUTW/TQBDdhKZN0vCVitBCK1IICHFwAAmE1Kr0iwiqABLpoSIXNvYq2XbtXdZr6l4QP4GfAHcuSNw4IQ6cOXBB/AWEOHBFzNqJXbcujdQcHGdm3ps3k5l59xPlXIlmN7HvG9JzFLWJsba0sfG4s0lMtUpcU1KhuEThJ5NF2TYatyK7q9CldlPD6314fYXbgjvE2YWea6Kiq3YYcXuEKIVmkgjTdeutyD3nC08OWCNRaaxvfv/KvrZevc0i5AtQV4JSqoeh4kpGmihLLYXKkOkFrjPsdEGGpE4X9B7XthWGXfcRtslz9BKNNdGowBLIFLo4fMkBR4D3hUKF2toqxYx3ryt0jcuuYfa4JLbBqI0NjxrAIXc6nG8Z9/TbMrw1uLSFCChGgYAM7ApV9xKAj6qdGBrD8tiyWgorotBpXZmhqzUghhHsxGFjtXXcYQTETSb66G5DV4zApyMLMW9trYk7hAGirHn9fmho1UHlKLYcSV/hFmlQwqD5lQRqnfgqcCSRxdoqNz0b8JBnajdCAcAYOMU+WTf077NJsolIRhASpTt3UM6AZCYmL5nYMQlb9pTiDvAlKgitSao834rNV/o+ic4nWgxLYMRLEE9ppo1y0gMz/Cft/XvzBFzhxkzu2RhNGHj/Via+ffzxoTFYkzzkPpMaumvLYXyF5IJIRXXqk+GOeIqy+kMs5tqo4BIGJyI4AdMpwlp9N4iDfOHQabhxH7s9oMiNff/0ufLs6zGUbaAi49hqYB3/ABVUT0IXOLN8cXcxUFTazsPzlNamUM7mFmYwT/PUYdQhVaxgazueIgs+9GE6pQ+RmE7hy5+J1vvFQS8yoG3qwPC4H7mnaDTMFhyN/j1IPRLjwiWexeO9T7sEGf1dFP2hMoLnzbRiR/SEa+8t39NftwPR+u1OwFE5lEOb5xU6MW9hhasd6lgwqAvpbFPDsf1Hz4UhasoTi6rBLVlK55kdXsnRGQ6o5fKRGa4Cwz8t5ZqAZAcAAA==";
    public static final String PROPERTY$DOCUMENT0 = "$Document0";
    public static final String PROPERTY$DOCUMENT1 = "$Document1";
    private static final Log log = LogFactory.getLog(org.chorem.lima.ui.entrybook.EntryBookForm.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected java.util.List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new java.util.TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?,?> $previousValues = new java.util.HashMap<Object, Object>();
    private boolean allComponentsCreated;
    private boolean contextInitialized = true;
    protected final JAXXContext delegateContext = new jaxx.runtime.context.DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected java.lang.Boolean addState;
    protected javax.swing.JButton cancelButton;
    protected org.chorem.lima.entity.EntryBook entryBook;
    protected javax.swing.JTextField entryBookCodeField;
    protected javax.swing.JTextField entryBookLabelField;
    protected javax.swing.JButton okButton;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private EntryBookForm $JDialog0 = this;
    private jaxx.runtime.swing.Table $Table0;
    private javax.swing.JLabel $JLabel0;
    private javax.swing.text.Document $Document0;
    private javax.swing.JLabel $JLabel1;
    private javax.swing.text.Document $Document1;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/
    
        protected void performCancel() {
            setEntryBook(null);
            dispose();
        }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public EntryBookForm() {
        $initialize();
    }

    public EntryBookForm(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                $bindings.get($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__cancelButton(java.awt.event.ActionEvent event) {
        performCancel();
    }

    public void doActionPerformed__on__okButton(java.awt.event.ActionEvent event) {
        dispose();
    }

    public void doInsertUpdate__on__$Document1(javax.swing.event.DocumentEvent event) {
        getEntryBook().setLabel(getEntryBookLabelField().getText());
    }

    public void doRemoveUpdate__on__$Document1(javax.swing.event.DocumentEvent event) {
        getEntryBook().setLabel(getEntryBookLabelField().getText());
    }

    public void doInsertUpdate__on__$Document0(javax.swing.event.DocumentEvent event) {
        getEntryBook().setCode(getEntryBookCodeField().getText());
    }

    public void doRemoveUpdate__on__$Document0(javax.swing.event.DocumentEvent event) {
        getEntryBook().setCode(getEntryBookCodeField().getText());
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public java.lang.Boolean getAddState() {
        return addState;
    }

    public javax.swing.JButton getCancelButton() {
        return cancelButton;
    }

    public org.chorem.lima.entity.EntryBook getEntryBook() {
        return entryBook;
    }

    public javax.swing.JTextField getEntryBookCodeField() {
        return entryBookCodeField;
    }

    public javax.swing.JTextField getEntryBookLabelField() {
        return entryBookLabelField;
    }

    public javax.swing.JButton getOkButton() {
        return okButton;
    }

    public java.lang.Boolean isAddState() {
        return addState !=null && addState;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void set$Document0(javax.swing.text.Document newValue) {
        javax.swing.text.Document oldValue = this.$Document0;
        this.$Document0 = newValue;
        firePropertyChange(PROPERTY$DOCUMENT0, oldValue, newValue);
    }

    public void set$Document1(javax.swing.text.Document newValue) {
        javax.swing.text.Document oldValue = this.$Document1;
        this.$Document1 = newValue;
        firePropertyChange(PROPERTY$DOCUMENT1, oldValue, newValue);
    }

    public void setAddState(java.lang.Boolean newValue) {
        java.lang.Boolean oldValue = this.addState;
        this.addState = newValue;
        firePropertyChange(PROPERTY_ADD_STATE, oldValue, newValue);
    }

    public void setEntryBook(org.chorem.lima.entity.EntryBook newValue) {
        org.chorem.lima.entity.EntryBook oldValue = this.entryBook;
        this.entryBook = newValue;
        firePropertyChange(PROPERTY_ENTRY_BOOK, oldValue, newValue);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected jaxx.runtime.swing.Table get$Table0() {
        return $Table0;
    }

    protected javax.swing.JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected javax.swing.text.Document get$Document0() {
        return $Document0;
    }

    protected javax.swing.JLabel get$JLabel1() {
        return $JLabel1;
    }

    protected javax.swing.text.Document get$Document1() {
        return $Document1;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void createAddState() {
        $objectMap.put("addState", addState = true);
    }

    protected void createCancelButton() {
        $objectMap.put("cancelButton", cancelButton = new javax.swing.JButton());
        
        cancelButton.setName("cancelButton");
        cancelButton.setText(_("lima.common.cancel"));
        cancelButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__cancelButton"));
    }

    protected void createEntryBook() {
        $objectMap.put("entryBook", entryBook = null);
    }

    protected void createEntryBookCodeField() {
        $objectMap.put("entryBookCodeField", entryBookCodeField = new javax.swing.JTextField());
        
        entryBookCodeField.setName("entryBookCodeField");
        entryBookCodeField.setColumns(15);
    }

    protected void createEntryBookLabelField() {
        $objectMap.put("entryBookLabelField", entryBookLabelField = new javax.swing.JTextField());
        
        entryBookLabelField.setName("entryBookLabelField");
        entryBookLabelField.setColumns(15);
    }

    protected void createOkButton() {
        $objectMap.put("okButton", okButton = new javax.swing.JButton());
        
        okButton.setName("okButton");
        okButton.setText(_("lima.common.ok"));
        okButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__okButton"));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        // inline complete setup of $JDialog0
        add($Table0);
        // inline complete setup of $Table0
        $Table0.add($JLabel0, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(entryBookCodeField, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JLabel1, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(entryBookLabelField, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(cancelButton, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(okButton, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        
        // apply 3 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // late initializer
        $JDialog0.pack();
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        $objectMap.put("$JDialog0", this);
        createEntryBook();
        createAddState();
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new jaxx.runtime.swing.Table());
        
        $Table0.setName("$Table0");
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new javax.swing.JLabel());
        
        $JLabel0.setName("$JLabel0");
        $JLabel0.setText(_("lima.common.code"));
        createEntryBookCodeField();
        // inline creation of $Document0
        $objectMap.put("$Document0", $Document0 = getEntryBookCodeField().getDocument());
        
        $Document0.addDocumentListener(JAXXUtil.getEventListener(DocumentListener.class, "insertUpdate", this, "doInsertUpdate__on__$Document0"));
        $Document0.addDocumentListener(JAXXUtil.getEventListener(DocumentListener.class, "removeUpdate", this, "doRemoveUpdate__on__$Document0"));
        // inline creation of $JLabel1
        $objectMap.put("$JLabel1", $JLabel1 = new javax.swing.JLabel());
        
        $JLabel1.setName("$JLabel1");
        $JLabel1.setText(_("lima.common.label"));
        createEntryBookLabelField();
        // inline creation of $Document1
        $objectMap.put("$Document1", $Document1 = getEntryBookLabelField().getDocument());
        
        $Document1.addDocumentListener(JAXXUtil.getEventListener(DocumentListener.class, "insertUpdate", this, "doInsertUpdate__on__$Document1"));
        $Document1.addDocumentListener(JAXXUtil.getEventListener(DocumentListener.class, "removeUpdate", this, "doRemoveUpdate__on__$Document1"));
        createCancelButton();
        createOkButton();
        // inline creation of $JDialog0
        setName("$JDialog0");
        setModal(true);
        
        getRootPane().setDefaultButton(okButton);// registers 3 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 3 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_ENTRY_BOOK_CODE_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                addPropertyChangeListener("entryBook", this);
                if (getEntryBook() != null) {
                    getEntryBook().addPropertyChangeListener("code", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getEntryBook() != null) {
                    jaxx.runtime.SwingUtil.setText(entryBookCodeField, getEntryBook().getCode());
                }
            }
        
            @Override
            public void removeDataBinding() {
                removePropertyChangeListener("entryBook", this);
                if (getEntryBook() != null) {
                    getEntryBook().removePropertyChangeListener("code", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_ENTRY_BOOK_LABEL_FIELD_EDITABLE, true ,"addState") {
        
            @Override
            public void processDataBinding() {
                entryBookLabelField.setEditable(isAddState());
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_ENTRY_BOOK_LABEL_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                addPropertyChangeListener("entryBook", this);
                if (getEntryBook() != null) {
                    getEntryBook().addPropertyChangeListener("label", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getEntryBook() != null) {
                    jaxx.runtime.SwingUtil.setText(entryBookLabelField, getEntryBook().getLabel());
                }
            }
        
            @Override
            public void removeDataBinding() {
                removePropertyChangeListener("entryBook", this);
                if (getEntryBook() != null) {
                    getEntryBook().removePropertyChangeListener("label", this);
                }
            }
        });
    }

}