/*
 * #%L
 * Lima Swing
 * 
 * $Id: DateTableCellEditor.java 3049 2010-11-29 14:34:09Z echatellier $
 * $HeadURL: http://svn.chorem.org/svn/lima/tags/lima-0.4.3/lima-swing/src/main/java/org/chorem/lima/ui/celleditor/DateTableCellEditor.java $
 * %%
 * Copyright (C) 2008 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

package org.chorem.lima.ui.celleditor;

import org.chorem.lima.LimaContext;
import org.jdesktop.swingx.JXDatePicker;

import javax.swing.*;
import javax.swing.table.TableCellEditor;
import java.awt.*;
import java.awt.event.MouseEvent;
import java.util.Date;
import java.util.EventObject;

/**
 * @author ore
 */
public class DateTableCellEditor extends AbstractCellEditor implements TableCellEditor {

    private final JXDatePicker datePicker;
    private static final long serialVersionUID = 1L;
    private static DateTableCellEditor editor;

    /**
     * constructor
     */
    public DateTableCellEditor() {
        datePicker = new JXDatePicker(LimaContext.getContext().getConfig().getLocale());
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        if (value instanceof Date) {
            datePicker.setDate((Date) value);
        }
        return datePicker;
    }

    @Override
    public Object getCellEditorValue() {
        return datePicker.getDate();
    }

    @Override
    public boolean isCellEditable(EventObject evt) {
        return !(evt instanceof MouseEvent) || ((MouseEvent) evt).getClickCount() == 2;
    }

    public static DateTableCellEditor getInstance() {
        if (editor == null) {
            editor = new DateTableCellEditor();
        }
        return editor;
    }
}
