/*
 * #%L
 * Lima Swing
 * 
 * $Id: LetterToString.java 3051 2010-11-29 14:57:16Z echatellier $
 * $HeadURL: http://svn.chorem.org/svn/lima/tags/lima-0.4.2/lima-swing/src/main/java/org/chorem/lima/util/LetterToString.java $
 * %%
 * Copyright (C) 2008 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

package org.chorem.lima.util;

import org.chorem.lima.entity.Letter;
import org.jdesktop.swingx.autocomplete.ObjectToStringConverter;

public class LetterToString extends ObjectToStringConverter {
    
    private static LetterToString converter;
    
    @Override
    public String getPreferredStringForItem(Object item) {
        String result = null;
        if (item != null){
            if (item instanceof Letter){
                Letter letter = (Letter) item;
                result = letter.getCode();    
            }
        }
        return result;
    }

    public static LetterToString getInstance() {
        if (converter == null) {
            converter = new LetterToString();
        }
        return converter;
    }
    
}
