/*
 * #%L
 * Lima Swing
 * 
 * $Id: LedgerViewHandler.java 3051 2010-11-29 14:57:16Z echatellier $
 * $HeadURL: http://svn.chorem.org/svn/lima/tags/lima-0.4.2/lima-swing/src/main/java/org/chorem/lima/ui/ledger/LedgerViewHandler.java $
 * %%
 * Copyright (C) 2008 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

package org.chorem.lima.ui.ledger;

import static org.nuiton.i18n.I18n._;
import java.awt.Desktop;
import java.io.IOException;
import java.math.BigDecimal;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.LimaConfig;
import org.chorem.lima.beans.BalanceTrial;
import org.chorem.lima.beans.ReportsDatas;
import org.chorem.lima.business.DocumentServiceMonitorable;
import org.chorem.lima.business.FinancialTransactionServiceMonitorable;
import org.chorem.lima.business.HttpServerServiceMonitorable;
import org.chorem.lima.business.ImportServiceMonitorable;
import org.chorem.lima.business.LimaException;
import org.chorem.lima.business.ReportServiceMonitorable;
import org.chorem.lima.business.ServiceListener;
import org.chorem.lima.business.utils.DocumentsEnum;
import org.chorem.lima.business.utils.EntryComparator;
import org.chorem.lima.business.utils.FormatsEnum;
import org.chorem.lima.entity.Entry;
import org.chorem.lima.service.LimaServiceFactory;
import org.chorem.lima.util.ErrorHelper;


/**
 * Handler associated with accounts reports view.
 * By : $Author: echatellier $
 */
public class LedgerViewHandler implements ServiceListener {

    protected LedgerView view;

    protected LedgerTableModel model;
    
    /** log. */
    private static final Log log = LogFactory.getLog(LedgerTableModel.class);

    /** Services. */
    protected ReportServiceMonitorable reportService;
    protected DocumentServiceMonitorable documentService;
    
    /** Begin Date. */
    protected Date selectedBeginDate;
    
    /** EndDate. */
    protected Date selectedEndDate;
    
    /** Text field Accounts */
    protected String selectedAccounts;
    
    protected BalanceTrial balanceTrialCache;

    private static SimpleDateFormat dateFormat =
        new SimpleDateFormat("yyyy-MM-dd");
    
    protected int port;
    
    protected List<Object> cachedatasList;
        
    protected LedgerViewHandler(LedgerView view) {
        this.view = view;
        
        reportService =
            LimaServiceFactory.getInstance().getService(
                    ReportServiceMonitorable.class);
        reportService.addListener(this);
        port = LimaServiceFactory.getInstance().getService(
                HttpServerServiceMonitorable.class).getHttpPort();
        documentService =
            LimaServiceFactory.getInstance().getService(
                    DocumentServiceMonitorable.class);
        LimaServiceFactory.getInstance().getService(
                ImportServiceMonitorable.class).addListener(this);
        LimaServiceFactory.getInstance().getService(
                FinancialTransactionServiceMonitorable.class).addListener(this);
    }
    
    public void setBeginDate(Date date){
        selectedBeginDate = date;
    }
    
    public void setEndDate(Date date){
        selectedEndDate = date;
    }
    
    public void setAccountFilter(String accounts) {
        selectedAccounts = accounts;
        refresh();
    }
    
    /**
     * get all account fot the selected period
     * @return
     */
    public List<Object> getDataList(){
        List<Object> results = new ArrayList<Object>();
        try {
            balanceTrialCache = reportService.generateLedger(selectedBeginDate,
                    selectedEndDate, selectedAccounts,
                    view.getMovmentedFilter().isSelected());
            if (balanceTrialCache.getReportsDatas() != null){
                for (ReportsDatas reportsDatas : balanceTrialCache.getReportsDatas()) {         
                    results.add(reportsDatas);
                    List<Entry> entries = (List<Entry>) reportsDatas.getListEntry();
                    if (entries != null){
                        Collections.sort(entries, new EntryComparator());
                        results.addAll(entries);   
                    }
                }
            }
        }
        catch (LimaException eee) {
            if (log.isErrorEnabled()) {
                log.debug("Can't update model", eee);
            }
            ErrorHelper.showErrorDialog("Can't get entries list", eee);
        }
        return results;
    }
    
    public void refresh(){
        if (selectedBeginDate != null && selectedEndDate != null){
            model = view.getModelTable();
            cachedatasList = getDataList();
            model.refresh(cachedatasList);
        
        /**
         * set text and amounts of labels credit, debit, solde
         */
            
            if (balanceTrialCache != null){
                // set amounts credit, debit and solde
                view.amountCreditLabel.setText(
                        String.valueOf(balanceTrialCache.getAmountCredit()));
                view.amountDebitLabel.setText(
                        String.valueOf(balanceTrialCache.getAmountDebit()));            
                BigDecimal amountSolde = balanceTrialCache.getAmountSolde();
                view.amountSoldeLabel.setText(
                        String.valueOf(amountSolde));
                
                if (amountSolde.doubleValue() == 0){
                    view.soldeLabel.setText(_("lima.common.solde"));
                }
                else {
                    // set label solde: credit or debit
                    if (balanceTrialCache.getSoldeDebit()) {
                        view.soldeLabel.setText(_("lima.common.soldedebit"));
                    }
                    else {
                        view.soldeLabel.setText(_("lima.common.soldecredit"));
                    }
                }
            }
        }
    }
    
    public void createDocument() {
        
        if (selectedBeginDate != null && selectedEndDate != null){
            FormatsEnum selectedEnum = (FormatsEnum) view.getDocumentEditor().getSelectedItem();
            String address = LimaConfig.getInstance().getHostAdress();
            
            try {
                String url = "http://"+address+":"+port+"/?beginDate="
                +dateFormat.format(selectedBeginDate)
                +"&endDate="+dateFormat.format(selectedEndDate)
                +"&format="+selectedEnum.getExtension()+"&model="
                + DocumentsEnum.LEDGER.getFileName();
                Desktop.getDesktop().browse(new URI(url));            
            } catch (IOException e) {
                log.error("Can't open browser", e);
            } catch (URISyntaxException e) {
                log.error("Can't create news URI", e);
            }
        }
    }
    
    @Override
    public void notifyMethod(String serviceName, String methodeName) {
        if (serviceName.contains("FinancialTransaction") || methodeName.contains("importAccount") || methodeName.contains("importAll")){
            refresh();
        }
    }
    
}
