/*
 * #%L
 * Lima Swing
 * 
 * $Id: AccountComboBoxModel.java 3051 2010-11-29 14:57:16Z echatellier $
 * $HeadURL: http://svn.chorem.org/svn/lima/tags/lima-0.4.1/lima-swing/src/main/java/org/chorem/lima/ui/combobox/AccountComboBoxModel.java $
 * %%
 * Copyright (C) 2008 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

package org.chorem.lima.ui.combobox;

import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.business.AccountServiceMonitorable;
import org.chorem.lima.business.ImportServiceMonitorable;
import org.chorem.lima.business.LimaException;
import org.chorem.lima.business.ServiceListener;
import org.chorem.lima.entity.Account;
import org.chorem.lima.service.LimaServiceFactory;
import org.chorem.lima.ui.financialperiod.FinancialPeriodTableModel;

/**
 * Account combo box model.
 */

public class AccountComboBoxModel extends AbstractListModel implements ComboBoxModel, ServiceListener {
    
    private static final long serialVersionUID = 1L;

    private static final Log log =
        LogFactory.getLog(FinancialPeriodTableModel.class);
    
    protected Object selectedAccount;
    
    protected List<Account> datasCache;
    
    protected AccountServiceMonitorable accountService;
        
    public AccountComboBoxModel () {
        accountService =
            LimaServiceFactory.getInstance().getService(
                    AccountServiceMonitorable.class);
        accountService.addListener(this);
        LimaServiceFactory.getInstance().getService(
                ImportServiceMonitorable.class).addListener(this);
        datasCache = getDataList();
    }
    
    @Override
    public Object getSelectedItem() {
       return selectedAccount;
    }

    @Override
    public void setSelectedItem(Object anItem) {
        selectedAccount = anItem;
        fireContentsChanged(this, -1, -1); 
    }


    @Override
    public Object getElementAt(int index) {
        return datasCache.get(index);
    }

    @Override
    public int getSize() {
         return datasCache.size();
    }

    public List<Account> getDataList(){
        List<Account> result = null;
        try {
            result = accountService.getAllAccounts();
        }
        catch (LimaException eee) {
            if (log.isDebugEnabled()){
                log.debug("Can't get list accounts", eee);
            }
        }
        return result;
        
    }
    
    public void refresh(){
        datasCache = getDataList();
        fireContentsChanged(this, 0, datasCache.size());
    }

    @Override
    public void notifyMethod(String serviceName, String methodeName) {
        if (methodeName.contains("Account") || methodeName.contains("importAll")){
            refresh();
        }        
    }

    
}
