/* *##% Lima Swing
 * Copyright (C) 2008 - 2010 CodeLutin
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * ##%*/

package org.chorem.lima.ui.lettering;

import static org.nuiton.i18n.I18n._;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.business.FinancialTransactionServiceMonitorable;
import org.chorem.lima.business.LimaException;
import org.chorem.lima.entity.Letter;
import org.chorem.lima.service.LimaServiceFactory;
import org.chorem.lima.ui.combobox.FinancialPeriodComboBoxModel;
import org.chorem.lima.ui.combobox.FiscalPeriodComboBoxModel;
import org.chorem.lima.util.DialogHelper;


/**
 * Handler associated with financial transaction view.
 * 
 * @author chatellier
 * @version $Revision: 3015 $
 * 
 * Last update : $Date: 2010-08-23 18:38:53 +0200 (lun., 23 août 2010) $
 * By : $Author: jpepin $
 */
public class LetteringViewHandler {

    /** log. */
    private static final Log log =
        LogFactory.getLog(LetteringViewHandler.class);

    protected LetteringView view;
    
    protected LetteringTable table;
    
    protected LetteringTableModel tableModel;
    
    protected FiscalPeriodComboBoxModel fiscalPeriodComboBoxModel;
    
    protected FinancialPeriodComboBoxModel financialPeriodComboBoxModel;
    
    /** Transaction service. */
    protected final FinancialTransactionServiceMonitorable financialTransactionService;
    
    protected Object clipBoard;

    protected LetteringViewHandler(LetteringView view) {
        this.view = view;
        
        /* Services */
    	financialTransactionService =
        	LimaServiceFactory.getInstance().getService(
        			FinancialTransactionServiceMonitorable.class);
    }    
    

    
   public void addLetter(){
	   Letter letter = null;
	   Boolean valid = true;
	   
	   table = view.getTable();
	   tableModel = view.getTableModel();
	   
	   AddLetterForm addLetterForm = new AddLetterForm();
	   JTextField newLetterTextField = addLetterForm.getNewLetterTextField();

	   try {
		   letter = financialTransactionService.getNewLetter();
		   newLetterTextField.setText(letter.getCode());
	   } catch (LimaException eee) {
		   log.error("Can't get new letter", eee);
	   }
	   
	   addLetterForm.setLocationRelativeTo(view);
	   addLetterForm.setVisible(true);
	   
	   //false = cancel Action
	   if (addLetterForm.validOk){
		   Object object = addLetterForm.getRadioButtons().getSelectedValue();
		   if (!(Boolean) object){
			   JComboBox comboBox = addLetterForm.getLetterListComboBox();
			   Object selectedObject = comboBox.getSelectedItem();
			   if (selectedObject instanceof Letter){
				   letter = (Letter) selectedObject;
			   }
			   else {
		       		DialogHelper.showMessageDialog(_("lima.entries.lettering.noletterselected"));
		       		valid = false;
			   }
		   }
		   if (valid){
			   //addLetters
			   int[] rows = table.getSelectedRows();
			   for (int i : rows) {
				   tableModel.setLetter(i, letter);
				}
			   tableModel.refresh();
		   }
	   } 
   }
   
   public void removeLetter(){

	   table = view.getTable();
	   tableModel = view.getTableModel();
	   
	   //removeLetters
	   int[] rows = table.getSelectedRows();
	   for (int i : rows) {
		   tableModel.removeLetter(i);
		}
	   tableModel.refresh();
   }
   
    public void refresh(){
        tableModel = view.getTableModel();
        tableModel.refresh();
    }
}
