/* *##% Lima Swing
 * Copyright (C) 2008 - 2010 CodeLutin
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * ##%*/

package org.chorem.lima.ui.lettering;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComboBox;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.entity.FinancialPeriod;
import org.chorem.lima.ui.combobox.FinancialPeriodComboBoxModel;
import org.chorem.lima.ui.combobox.FinancialPeriodComboBoxRenderer;


public class LetteringFinancialPeriodComboBox extends JComboBox implements ActionListener {

	private static final long serialVersionUID = 1L;

    private static final Log log =
        LogFactory.getLog(LetteringFinancialPeriodComboBox.class);
	
	protected LetteringViewHandler handler;
	
	public LetteringFinancialPeriodComboBox(LetteringViewHandler handler) {
		this.handler = handler;

		FinancialPeriodComboBoxModel comboBoxModel = new FinancialPeriodComboBoxModel();
		FinancialPeriodComboBoxRenderer comboBoxRenderer = new FinancialPeriodComboBoxRenderer();

		setModel(comboBoxModel);
		setRenderer(comboBoxRenderer);
		addActionListener(this);

	}

	public void back(){
		int row = this.getSelectedIndex();
		log.debug(row);
		if (row > 0){
			this.setSelectedItem(this.getItemAt(row-1));
			repaint();
			handler.tableModel.setFinancialPeriod( (FinancialPeriod) this.getSelectedItem());
		}
	}
	
	public void next(){
		int size = this.getModel().getSize();
		int row = this.getSelectedIndex();
		log.debug(row);
		
		if (row < size-1){
			this.setSelectedItem(this.getItemAt(row+1));
			repaint();
			handler.tableModel.setFinancialPeriod( (FinancialPeriod) this.getSelectedItem());
		}
	}
	
	@Override
	public void actionPerformed(ActionEvent e) {
		Object object = this.getSelectedItem();
		if (object instanceof FinancialPeriod){
			handler.tableModel.setFinancialPeriod( (FinancialPeriod) this.getSelectedItem());
		}
	}
	
}
