package org.chorem.lima.ui.ledger;

import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.lang.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import jaxx.runtime.*;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.swing.*;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.enums.ComboBoxDatesEnum;
import org.chorem.lima.ui.ledger.*;
import static jaxx.runtime.SwingUtil.createImageIcon;
import static org.nuiton.i18n.I18n._;

public class LedgerView extends jaxx.runtime.swing.Table implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_HANDLER = "handler";
    public static final String PROPERTY_PERIOD_COMBO_BOX = "periodComboBox";
    public static final String PROPERTY_SELECTED_ROW = "selectedRow";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVVz28bRRSeuHUSOw39kTYkaotC61aoldZNOHBIRH+4NWnk0qobSsES6uzuyJ52dmeZma23HBB/Qv8EuHNB6q0nxIEzBy6IfwEhDlwRb2a9u157U1uND7veee/73nvfzLz341+oKgV6/ymOY0tEgaI+sfZuPn5833lKXHWbSFfQUHGBkt9cBVW6aMnL1qVCF7sdDW8O4c0W90MekGAEvd1BdaleMCL7hCiFzhcRrpRNOzNvx2EkUtYsqTLW7//5u/LS++6HCkJxCNmtQSkb01B5JUc7qEI9hU5BpOe4yXDQgzQEDXqQ77JeazEs5afYJ1+jb9FCB82HWACZQhdmL9lwGHwcKrTQ2McOI9cUanDRs9w+F8S3GPWxFVGLEa9HhNUxr0eUDMLQQOcB2MeBx4hQ6OoswN3EO8cvScJgR4n3kA8UOqmrs3TF1i3OGcFB7vmOzz3C7gRKvADbM4W2SgK63He4w2Mr82vplVs8vqfROVvdsJmiFboyLXXjN8aw0rCNpncDqihm9BsiQL7LZp8hjZBCnVYiuzXhOSJgovymQmuFIyIHsOGWsWnPWq5DSATlXlqXQme0aPEQsJeua++zGWi9kRTywGBtgoXbf4ADwiDlzWnVT4CK3IuNvQ52DNWpQipmtZj8soNhd13SpkzpQ7NaAOyTWLUpYV4RVG/c5m7kwzmGEOujCAUAKzXmmh73+XO9Qrw0zphGfeI+G2o0ImxKdMejcFPgKpRsCDE2OF6Rn7iN1dfYg73mjGmdINt3C3FzUxFVVck5vDTTOdSgDzPs6UaHSmWbW0R5YA4pBH5vNPCkx8T529Kf54tppRu7qb8v68dOZjuBfR7pxuJQle3zmE+K3yqxnUzwLaEFPYigLjnzyEHWYQp2qY9AZwu7B73cynt53mznuqgqIliG+9edbP8PwZQ0/rWxxq8JjfW/1ZXfX//5qp12+2MQ+0yp68iwgi4cCg43WVEd+njS6iNFWfMeDre7qJb0RTPJzpUkZg/NkBzES/qmhlu7WPaBorrwx8+/rD757QiqtFGdcey1sfa/i2qqL0AFUC0Or98wGR0bLMLzhM5NoaP6UsFV3qEBowHZwApmjxMp8nEMMpwrkSHLxan9+u+K/dONVIo5SG39QPdcjuqXaD6JZkbfcKqVjrqlUJLI4/n0Kptnc/p9KRwe8vvmaZfVuuTTgPqRb0NPhgaw42GFNxwaeHBroFyN+9zUof99YWg/mIVWwfDap6HuZ9rp0dtTLabz8Q081lQevfzZoRigSZmJqc1flZN8NANJTfDBLqG9/pt0mYVoWY72s0NmtSih3aet9a2Tmiby9UMztA7N8Akw/A883ULAXQsAAA==";
    public static final String PROPERTY$LEDGER_PERIOD_SEARCH_PANEL0 = "$LedgerPeriodSearchPanel0";
    public static final String PROPERTY$DOCUMENT0 = "$Document0";
    public static final String PROPERTY$LIST_SELECTION_MODEL0 = "$ListSelectionModel0";
    private static final Log log = LogFactory.getLog(org.chorem.lima.ui.ledger.LedgerView.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected java.util.List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new java.util.TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?,?> $previousValues = new java.util.HashMap<Object, Object>();
    private boolean allComponentsCreated;
    private boolean contextInitialized = true;
    protected final JAXXContext delegateContext = new jaxx.runtime.context.DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected jaxx.runtime.swing.editor.EnumEditor DocumentEditor;
    protected javax.swing.JLabel amountCreditLabel;
    protected javax.swing.JLabel amountDebitLabel;
    protected javax.swing.JLabel amountSoldeLabel;
    protected javax.swing.JTextField balanceFilter;
    protected org.chorem.lima.ui.ledger.LedgerViewHandler handler;
    protected org.chorem.lima.ui.combobox.EntryBookComboBoxModel modelEntryBook;
    protected org.chorem.lima.ui.ledger.LedgerTableModel modelTable;
    protected javax.swing.JCheckBox movmentedFilter;
    protected javax.swing.JComboBox periodComboBox;
    protected java.lang.Boolean selectedRow;
    protected javax.swing.JLabel soldeLabel;
    protected org.chorem.lima.ui.ledger.LedgerTable table;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private LedgerView $Table0 = this;
    private jaxx.runtime.swing.Table $Table1;
    private org.chorem.lima.ui.ledger.LedgerPeriodSearchPanel $LedgerPeriodSearchPanel0;
    private javax.swing.JLabel $JLabel0;
    private javax.swing.text.Document $Document0;
    private javax.swing.JScrollPane $JScrollPane0;
    private javax.swing.ListSelectionModel $ListSelectionModel0;
    private jaxx.runtime.swing.Table $Table2;
    private javax.swing.JLabel $JLabel1;
    private javax.swing.JLabel $JLabel2;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    LedgerPeriodSearchPanel periodSearchPanel;
    
        
        void $afterCompleteSetup() {
        }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public LedgerView() {
        $initialize();
    }

    public LedgerView(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                $bindings.get($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__DocumentEditor(java.awt.event.ActionEvent event) {
        getHandler().createDocument();
    }

    public void doActionPerformed__on__movmentedFilter(java.awt.event.ActionEvent event) {
        getHandler().refresh();
    }

    public void doActionPerformed__on__periodComboBox(java.awt.event.ActionEvent event) {
        periodSearchPanel.refresh(ComboBoxDatesEnum.valueOfDescription((String) periodComboBox.getSelectedItem()));                     validate(); repaint();
    }

    public void doInsertUpdate__on__$Document0(javax.swing.event.DocumentEvent event) {
        handler.setAccountFilter(balanceFilter.getText());
    }

    public void doRemoveUpdate__on__$Document0(javax.swing.event.DocumentEvent event) {
        handler.setAccountFilter(balanceFilter.getText());
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public javax.swing.JLabel getAmountCreditLabel() {
        return amountCreditLabel;
    }

    public javax.swing.JLabel getAmountDebitLabel() {
        return amountDebitLabel;
    }

    public javax.swing.JLabel getAmountSoldeLabel() {
        return amountSoldeLabel;
    }

    public javax.swing.JTextField getBalanceFilter() {
        return balanceFilter;
    }

    public jaxx.runtime.swing.editor.EnumEditor getDocumentEditor() {
        return DocumentEditor;
    }

    public org.chorem.lima.ui.ledger.LedgerViewHandler getHandler() {
        return handler;
    }

    public org.chorem.lima.ui.combobox.EntryBookComboBoxModel getModelEntryBook() {
        return modelEntryBook;
    }

    public org.chorem.lima.ui.ledger.LedgerTableModel getModelTable() {
        return modelTable;
    }

    public javax.swing.JCheckBox getMovmentedFilter() {
        return movmentedFilter;
    }

    public javax.swing.JComboBox getPeriodComboBox() {
        return periodComboBox;
    }

    public java.lang.Boolean getSelectedRow() {
        return selectedRow;
    }

    public javax.swing.JLabel getSoldeLabel() {
        return soldeLabel;
    }

    public org.chorem.lima.ui.ledger.LedgerTable getTable() {
        return table;
    }

    public java.lang.Boolean isSelectedRow() {
        return selectedRow !=null && selectedRow;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void set$LedgerPeriodSearchPanel0(org.chorem.lima.ui.ledger.LedgerPeriodSearchPanel newValue) {
        org.chorem.lima.ui.ledger.LedgerPeriodSearchPanel oldValue = this.$LedgerPeriodSearchPanel0;
        this.$LedgerPeriodSearchPanel0 = newValue;
        firePropertyChange(PROPERTY$LEDGER_PERIOD_SEARCH_PANEL0, oldValue, newValue);
    }

    public void set$Document0(javax.swing.text.Document newValue) {
        javax.swing.text.Document oldValue = this.$Document0;
        this.$Document0 = newValue;
        firePropertyChange(PROPERTY$DOCUMENT0, oldValue, newValue);
    }

    public void set$ListSelectionModel0(javax.swing.ListSelectionModel newValue) {
        javax.swing.ListSelectionModel oldValue = this.$ListSelectionModel0;
        this.$ListSelectionModel0 = newValue;
        firePropertyChange(PROPERTY$LIST_SELECTION_MODEL0, oldValue, newValue);
    }

    public void setHandler(org.chorem.lima.ui.ledger.LedgerViewHandler newValue) {
        org.chorem.lima.ui.ledger.LedgerViewHandler oldValue = this.handler;
        this.handler = newValue;
        firePropertyChange(PROPERTY_HANDLER, oldValue, newValue);
    }

    public void setPeriodComboBox(javax.swing.JComboBox newValue) {
        javax.swing.JComboBox oldValue = this.periodComboBox;
        this.periodComboBox = newValue;
        firePropertyChange(PROPERTY_PERIOD_COMBO_BOX, oldValue, newValue);
    }

    public void setSelectedRow(java.lang.Boolean newValue) {
        java.lang.Boolean oldValue = this.selectedRow;
        this.selectedRow = newValue;
        firePropertyChange(PROPERTY_SELECTED_ROW, oldValue, newValue);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected jaxx.runtime.swing.Table get$Table1() {
        return $Table1;
    }

    protected org.chorem.lima.ui.ledger.LedgerPeriodSearchPanel get$LedgerPeriodSearchPanel0() {
        return $LedgerPeriodSearchPanel0;
    }

    protected javax.swing.JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected javax.swing.text.Document get$Document0() {
        return $Document0;
    }

    protected javax.swing.JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    protected javax.swing.ListSelectionModel get$ListSelectionModel0() {
        return $ListSelectionModel0;
    }

    protected jaxx.runtime.swing.Table get$Table2() {
        return $Table2;
    }

    protected javax.swing.JLabel get$JLabel1() {
        return $JLabel1;
    }

    protected javax.swing.JLabel get$JLabel2() {
        return $JLabel2;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void createAmountCreditLabel() {
        $objectMap.put("amountCreditLabel", amountCreditLabel = new javax.swing.JLabel());
        
        amountCreditLabel.setName("amountCreditLabel");
    }

    protected void createAmountDebitLabel() {
        $objectMap.put("amountDebitLabel", amountDebitLabel = new javax.swing.JLabel());
        
        amountDebitLabel.setName("amountDebitLabel");
    }

    protected void createAmountSoldeLabel() {
        $objectMap.put("amountSoldeLabel", amountSoldeLabel = new javax.swing.JLabel());
        
        amountSoldeLabel.setName("amountSoldeLabel");
    }

    protected void createBalanceFilter() {
        $objectMap.put("balanceFilter", balanceFilter = new javax.swing.JTextField());
        
        balanceFilter.setName("balanceFilter");
        balanceFilter.setColumns(15);
        balanceFilter.setToolTipText(_("lima.tooltip.filter"));
    }

    protected void createDocumentEditor() {
        $objectMap.put("DocumentEditor", DocumentEditor = new jaxx.runtime.swing.editor.EnumEditor(org.chorem.lima.business.utils.FormatsEnum.class));
        
        DocumentEditor.setName("DocumentEditor");
        DocumentEditor.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__DocumentEditor"));
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = new LedgerViewHandler(this));
    }

    protected void createModelEntryBook() {
        $objectMap.put("modelEntryBook", modelEntryBook = new org.chorem.lima.ui.combobox.EntryBookComboBoxModel());
    }

    protected void createModelTable() {
        $objectMap.put("modelTable", modelTable = new org.chorem.lima.ui.ledger.LedgerTableModel());
    }

    protected void createMovmentedFilter() {
        $objectMap.put("movmentedFilter", movmentedFilter = new javax.swing.JCheckBox());
        
        movmentedFilter.setName("movmentedFilter");
        movmentedFilter.setSelected(false);
        movmentedFilter.setText(_("lima.common.movmentedfilter"));
        movmentedFilter.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__movmentedFilter"));
    }

    protected void createPeriodComboBox() {
        $objectMap.put("periodComboBox", periodComboBox = new JComboBox(ComboBoxDatesEnum.descriptions()));
        
        periodComboBox.setName("periodComboBox");
        periodComboBox.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__periodComboBox"));
    }

    protected void createSelectedRow() {
        $objectMap.put("selectedRow", selectedRow = false);
    }

    protected void createSoldeLabel() {
        $objectMap.put("soldeLabel", soldeLabel = new javax.swing.JLabel());
        
        soldeLabel.setName("soldeLabel");
        soldeLabel.setText(_("lima.common.solde"));
    }

    protected void createTable() {
        $objectMap.put("table", table = new org.chorem.lima.ui.ledger.LedgerTable(getHandler()));
        
        table.setName("table");
        table.setRowHeight(24);
        table.setSortable(false);
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        // inline complete setup of $Table0
        add($Table1, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        add($JLabel0, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 13, 0, new Insets(3, 3, 3, 3), 0, 0));
        add(balanceFilter, new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        add(movmentedFilter, new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        add(DocumentEditor, new GridBagConstraints(4, 0, 1, 1, 1.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        add($JScrollPane0, new GridBagConstraints(0, 1, 8, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        add($Table2, new GridBagConstraints(0, 2, 7, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $Table1
        $Table1.add(periodComboBox, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($LedgerPeriodSearchPanel0, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(table);
        // inline complete setup of $Table2
        $Table2.add($JLabel1, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add(amountDebitLabel, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add($JLabel2, new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add(amountCreditLabel, new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add(soldeLabel, new GridBagConstraints(4, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add(amountSoldeLabel, new GridBagConstraints(5, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        
        // apply 3 property setters
        balanceFilter.setMinimumSize(balanceFilter.getPreferredSize());
        table.setModel(getModelTable());
        table.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        $objectMap.put("$Table0", this);
        createHandler();
        createSelectedRow();
        createModelEntryBook();
        createModelTable();
        periodSearchPanel = new LedgerPeriodSearchPanel(handler);
        // inline creation of $Table1
        $objectMap.put("$Table1", $Table1 = new jaxx.runtime.swing.Table());
        
        $Table1.setName("$Table1");
        createPeriodComboBox();
        // inline creation of $LedgerPeriodSearchPanel0
        $objectMap.put("$LedgerPeriodSearchPanel0", $LedgerPeriodSearchPanel0 = periodSearchPanel);
        
        $LedgerPeriodSearchPanel0.setName("$LedgerPeriodSearchPanel0");
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new javax.swing.JLabel());
        
        $JLabel0.setName("$JLabel0");
        $JLabel0.setText(_("lima.common.filter"));
        createBalanceFilter();
        // inline creation of $Document0
        $objectMap.put("$Document0", $Document0 = balanceFilter.getDocument());
        
        $Document0.addDocumentListener(JAXXUtil.getEventListener(DocumentListener.class, "insertUpdate", this, "doInsertUpdate__on__$Document0"));
        $Document0.addDocumentListener(JAXXUtil.getEventListener(DocumentListener.class, "removeUpdate", this, "doRemoveUpdate__on__$Document0"));
        createMovmentedFilter();
        createDocumentEditor();
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new javax.swing.JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        createTable();
        // inline creation of $ListSelectionModel0
        $objectMap.put("$ListSelectionModel0", $ListSelectionModel0 = getTable().getSelectionModel());
        // inline creation of $Table2
        $objectMap.put("$Table2", $Table2 = new jaxx.runtime.swing.Table());
        
        $Table2.setName("$Table2");
        // inline creation of $JLabel1
        $objectMap.put("$JLabel1", $JLabel1 = new javax.swing.JLabel());
        
        $JLabel1.setName("$JLabel1");
        $JLabel1.setText(_("lima.common.amountdebit"));
        createAmountDebitLabel();
        // inline creation of $JLabel2
        $objectMap.put("$JLabel2", $JLabel2 = new javax.swing.JLabel());
        
        $JLabel2.setName("$JLabel2");
        $JLabel2.setText(_("lima.common.amountcredit"));
        createAmountCreditLabel();
        createSoldeLabel();
        createAmountSoldeLabel();
        // inline creation of $Table0
        setName("$Table0");
        
        $completeSetup();
    }

}