/* *##% Lima Swing
 * Copyright (C) 2008 - 2010 CodeLutin
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * ##%*/

package org.chorem.lima.ui.financialtransactionsearch;

import static org.nuiton.i18n.I18n._;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.chorem.lima.entity.Account;
import org.chorem.lima.enums.ComboBoxAccountsEnum;

public class AccountSearchPanel extends JPanel {
	
	protected FinancialTransactionSearchViewHandler handler;
	
	public AccountSearchPanel(FinancialTransactionSearchViewHandler handler) {
		this.handler = handler;
	}
	
	static final long serialVersionUID = 1L;

	public void refresh(ComboBoxAccountsEnum comboBoxAccountsEnum){
		
		switch (comboBoxAccountsEnum) {
		case ALL:
			handler.setAccount(null);
			handler.refresh();
			this.removeAll();
			break;
			
		case ACCOUNT:
			final AccountSearchComboBox accountComboBox = new AccountSearchComboBox(handler);
			handler.setAccount((Account) accountComboBox.getSelectedItem());
			handler.refresh();
			this.removeAll();
			this.add(accountComboBox);
			break;
			
		case ACCOUNT_LIST:
			final JTextField accountsList = new JTextField(16);
			accountsList.setMinimumSize(accountsList.getPreferredSize());
			accountsList.setToolTipText(_("lima.tooltip.filter"));
	    	KeyListener accountsListKeyListener = new KeyListener() {
				
				@Override
				public void keyTyped(KeyEvent e) {
				}
				
				@Override
				public void keyReleased(KeyEvent e) {
					String accounts = accountsList.getText();
					//to prevent useless call to service
					if (!accounts.equals(handler.getAccountsList())){
						handler.setAccountsList(accounts);
					}
				}
				
				@Override
				public void keyPressed(KeyEvent e) {				
				}
			};
			accountsList.addKeyListener(accountsListKeyListener);
			handler.setAccountsList(accountsList.getText());
			handler.setAccount(null);
			this.removeAll();
			this.add(accountsList);
			break;
		}
		
	}
	
}
