/* *##% Lima Swing
 * Copyright (C) 2008 - 2010 CodeLutin
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * ##%*/

package org.chorem.lima.ui.financialstatementreport;

import javax.swing.table.*;
import javax.swing.*;
import org.chorem.lima.beans.FinancialStatementAmounts;
import java.awt.*;


/**
 * Permet de modifier l'apparence du tableau pour le bilan à l'actif
 * @author Rémi Chapelet
 */

public class FinancialStatementReportTableCellRenderer extends DefaultTableCellRenderer {

	private static final long serialVersionUID = 4682358397738816778L;

	@Override
    public Component getTableCellRendererComponent(JTable table, Object value,
        boolean isSelected, boolean hasFocus, int row, int column)
    {

        // Get table
        FinancialStatementReportTableModel financialStatementReportTableModel = (FinancialStatementReportTableModel) table.getModel();
        
        // Récupère le bilan de la ligne
        Object object = financialStatementReportTableModel.getElementAt(row);
    	Component cell = super.getTableCellRendererComponent(
                table, value, isSelected, hasFocus, row, column);
    	
        // Si le bilan est un soustotal, alors la ligne est en gras
        if (object instanceof FinancialStatementAmounts){
        	FinancialStatementAmounts financialStatementAmounts = (FinancialStatementAmounts) object;
        	
            if (financialStatementAmounts.getLevel() == 1)
            {
                setFont(new Font("Verdana", Font.BOLD, 14));
            }

            if (financialStatementAmounts.getHeader())
            {
                setFont(new Font("Verdana", Font.BOLD, 12));
            }
            if (!financialStatementAmounts.getHeader() && !financialStatementAmounts.getSubAmount()){
            	if (column == 0){
            		cell.setFont(new Font("Verdana", Font.ITALIC, 12));
            	}
            }
        }

        return this;
    }

}
