/* *##% Lima Swing
 * Copyright (C) 2008 - 2010 CodeLutin
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * ##%*/

package org.chorem.lima.ui.combobox;

import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.business.EntryBookServiceMonitorable;
import org.chorem.lima.business.ImportServiceMonitorable;
import org.chorem.lima.business.LimaException;
import org.chorem.lima.business.ServiceListener;
import org.chorem.lima.entity.EntryBook;
import org.chorem.lima.service.LimaServiceFactory;
import org.chorem.lima.ui.financialperiod.FinancialPeriodTableModel;

/**
 * Opened financial period combo box model.
 * 
 * @author chatellier
 * @version $Revision: 3007 $
 * 
 * Last update : $Date: 2010-08-19 23:13:17 +0200 (Jeu, 19 aoû 2010) $
 * By : $Author: jpepin $
 */
public class EntryBookComboBoxModel extends AbstractListModel implements ComboBoxModel, ServiceListener {

	private static final long serialVersionUID = 1L;

	private static final Log log =
		LogFactory.getLog(FinancialPeriodTableModel.class);
    
    protected Object selectedEntryBook;
    
    protected EntryBookServiceMonitorable entryBookService;

    protected List<EntryBook> cacheDatas;
    
    public EntryBookComboBoxModel() {
        entryBookService =
        	LimaServiceFactory.getInstance().getService(
        			EntryBookServiceMonitorable.class);
        entryBookService.addListener(this);
    	LimaServiceFactory.getInstance().getService(
    			ImportServiceMonitorable.class).addListener(this);
        cacheDatas = getDataList();
    }

    @Override
    public int getSize() {
            return cacheDatas.size();
    }

    @Override
    public Object getElementAt(int index) {
            return cacheDatas.get(index);
    }

    @Override
    public void setSelectedItem(Object anItem) {
        selectedEntryBook = anItem;
        fireContentsChanged(this, -1, -1);
    }

    @Override
    public Object getSelectedItem() {
        return selectedEntryBook;
    }
    
    /**
     * get the accounts list
     */
    public List<EntryBook> getDataList(){
       List<EntryBook> result = null;
       try {
           result = entryBookService.getAllEntryBooks();
       }
       catch (LimaException eee) {
           if (log.isDebugEnabled()){
               log.debug("Can't get list accounts", eee);
           }
       }
       return result;
    }
    
    
    public void refresh(){
    	cacheDatas = getDataList();
    	fireContentsChanged(this, 0, cacheDatas.size());
    }

	@Override
	public void notifyMethod(String serviceName, String methodeName) {
		if (methodeName.contains("EntryBook") || methodeName.contains("importAll")){
			refresh();
		}
	}
}
